/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;

public class SelectOperator
extends Operator<SelectDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] eval;
    transient Object[] output;
    private transient boolean isSelectStarNoCompute = false;

    protected SelectOperator() {
    }

    public SelectOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.isSelectStarNoCompute = true;
            return;
        }
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        this.eval = new ExprNodeEvaluator[colList.size()];
        for (int i = 0; i < colList.size(); ++i) {
            assert (colList.get(i) != null);
            this.eval[i] = ExprNodeEvaluatorFactory.get(colList.get(i), hconf);
        }
        if (HiveConf.getBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEEXPREVALUATIONCACHE)) {
            this.eval = ExprNodeEvaluatorFactory.toCachedEvals(this.eval);
        }
        this.output = new Object[this.eval.length];
        if (this.isLogInfoEnabled) {
            this.LOG.info("SELECT " + this.inputObjInspectors[0].getTypeName());
        }
        this.outputObjInspector = SelectOperator.initEvaluatorsAndReturnStruct(this.eval, ((SelectDesc)this.conf).getOutputColumnNames(), this.inputObjInspectors[0]);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        int i;
        if (this.isSelectStarNoCompute) {
            this.forward(row, this.inputObjInspectors[tag]);
            return;
        }
        try {
            for (i = 0; i < this.eval.length; ++i) {
                this.output[i] = this.eval[i].evaluate(row);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new HiveException("Error evaluating " + ((SelectDesc)this.conf).getColList().get(i).getExprString(), e);
        }
        this.forward(this.output, this.outputObjInspector);
    }

    @Override
    public String getName() {
        return SelectOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SEL";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SELECT;
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }

    @Override
    public boolean acceptLimitPushdown() {
        return true;
    }

    public boolean isIdentitySelect() {
        if (this.getNumParent() != 1) {
            return false;
        }
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            return true;
        }
        RowSchema orig = this.getSchema();
        RowSchema dest = this.getParentOperators().get(0).getSchema();
        if (orig.getSignature() == null && dest.getSignature() == null) {
            return true;
        }
        if (orig.getSignature() == null && dest.getSignature() != null || orig.getSignature() != null && dest.getSignature() == null) {
            return false;
        }
        if (orig.getSignature().size() != dest.getSignature().size() || orig.getSignature().size() != ((SelectDesc)this.conf).getColList().size()) {
            return false;
        }
        for (int i = 0; i < orig.getSignature().size(); ++i) {
            ColumnInfo origColumn = orig.getSignature().get(i);
            ColumnInfo destColumn = dest.getSignature().get(i);
            if (origColumn == null && destColumn == null) continue;
            if (origColumn == null && destColumn != null || origColumn != null && destColumn == null) {
                return false;
            }
            if (!origColumn.internalEquals(destColumn)) {
                return false;
            }
            if (!(((SelectDesc)this.conf).getColList().get(i) instanceof ExprNodeColumnDesc)) {
                return false;
            }
            ExprNodeColumnDesc col = (ExprNodeColumnDesc)((SelectDesc)this.conf).getColList().get(i);
            if (col.getColumn().equals(origColumn.getInternalName())) continue;
            return false;
        }
        return true;
    }
}

