/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.Nullable;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.util.concurrent.AbstractFuture;

@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@Nullable Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static void interruptCurrentThread() {
        Thread.currentThread().interrupt();
    }

    static void rethrowIfErrorOtherThanStackOverflow(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof Error && !(t instanceof StackOverflowError)) {
            throw (Error)t;
        }
    }

    static <V> V get(AbstractFuture<V> future) throws InterruptedException, ExecutionException {
        return future.blockingGet();
    }

    static <V> V get(AbstractFuture<V> future, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.blockingGet(timeout, unit);
    }

    private Platform() {
    }
}

