/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0011\"\u0001:B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\t\u0001\t#\n\u0019\u0003C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u0011Q\u0007\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0001\u0003oA\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA7\u0001\u0005\u0005I\u0011AA8\u0011%\t)\bAA\u0001\n\u0003\n9\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0001\u0002\b\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003';\u0011\"a.\"\u0003\u0003E\t!!/\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003wCaa\u0015\u000e\u0005\u0002\u0005M\u0007\"CAk5\u0005\u0005IQIAl\u0011%\tINGA\u0001\n\u0003\u000bY\u000eC\u0005\u0002bj\t\t\u0011\"!\u0002d\"I\u0011Q\u001f\u000e\u0002\u0002\u0013%\u0011q\u001f\u0002\u0006\u001d\u0006te\u000f\u001c\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M1\u0001aL\u001a7s}\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014EA\u000bD_:$\u0017\u000e^5p]\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005A:\u0014B\u0001\u001d\"\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0001\"s!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011k\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\t95(A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%\u0001D*fe&\fG.\u001b>bE2,'BA$<\u0003\u0011aWM\u001a;\u0016\u00035\u0003\"\u0001\r(\n\u0005=\u000b#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA+W/B\u0011\u0001\u0007\u0001\u0005\u0006\u0017\u0016\u0001\r!\u0014\u0005\u0006#\u0016\u0001\r!T\u0001\tI\u0006$\u0018\rV=qKV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^K\u0005)A/\u001f9fg&\u0011q\f\u0018\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\t\u00042\u0001Q2f\u0013\t!'JA\u0002TKF\u0004\"a\u00174\n\u0005\u001dd&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003i\u0019wN\u001c;fqRLe\u000eZ3qK:$WM\u001c;G_2$\u0017M\u00197f+\u0005Q\u0007C\u0001\u001el\u0013\ta7HA\u0004C_>dW-\u00198\u0002+\u0005dw/Y=t\u000bZ\fG.^1uK\u0012Le\u000e];ugV\tq\u000eE\u0002AG6\u000bAd^5uQ:+w/\u00117xCf\u001cXI^1mk\u0006$X\rZ%oaV$8\u000f\u0006\u0002Ve\")QN\u0003a\u0001_\u0006a!M]1oG\"<%o\\;qgV\tQ\u000fE\u0002AG>\fA!\u001a<bYR\u0011\u0001p\u001f\t\u0003ueL!A_\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004}\u0019A\u0005\t\u0019A?\u0002\u000b%t\u0007/\u001e;\u0011\u0005y|X\"A\u0012\n\u0007\u0005\u00051EA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9!a\u0005\u0002\u001eA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0005\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0012\u0005-!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005\u00191\r\u001e=\u0011\t\u0005%\u0011\u0011D\u0005\u0005\u00037\tYA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}Q\u00021\u0001\u0002\b\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R!VA\u0013\u0003SAa!a\n\u000f\u0001\u0004i\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003Wq\u0001\u0019A'\u0002\u00119,wOU5hQR\fAaY8qsR)Q+!\r\u00024!91j\u0004I\u0001\u0002\u0004i\u0005bB)\u0010!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIDK\u0002N\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fZ\u0014AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002X\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001a\u0011\u0007i\nI'C\u0002\u0002lm\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001_A9\u0011%\t\u0019\bFA\u0001\u0002\u0004\t9'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0002R!a\u001f\u0002\u0002bl!!! \u000b\u0007\u0005}4(\u0001\u0006d_2dWm\u0019;j_:LA!a!\u0002~\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u0017\u0011\u0012\u0005\t\u0003g2\u0012\u0011!a\u0001q\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019&a$\t\u0013\u0005Mt#!AA\u0002\u0005\u001d\u0014AB3rk\u0006d7\u000fF\u0002k\u0003+C\u0001\"a\u001d\u0019\u0003\u0003\u0005\r\u0001\u001f\u0015\u0014\u0001\u0005e\u0015qTAQ\u0003K\u000b9+a+\u0002.\u0006E\u00161\u0017\t\u0004a\u0005m\u0015bAAOC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAR\u00035{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3S\u0001j\u0003EU3ukJt7\u000f\t1fqB\u0014\u0018\u0007\u0019\u0011jM\u0002JGoJ:!]>$\bET1OY\u0001z'\u000f\t1fqB\u0014(\u0007\u0019\u0011pi\",'o^5tK:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\u000b\u0011K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015dCN$\bf\n(b\u001d\u001e\u0002\u0013m\u001d\u0011e_V\u0014G.Z\u0015-AE\u00124'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\u001ad\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qV\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003k\u000b\u0011cY8oI&$\u0018n\u001c8bY~3WO\\2t\u0003\u0015q\u0015M\u0014<m!\t\u0001$dE\u0003\u001b\u0003{\u000bI\rE\u0004\u0002@\u0006\u0015W*T+\u000e\u0005\u0005\u0005'bAAbw\u00059!/\u001e8uS6,\u0017\u0002BAd\u0003\u0003\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\tY-!5\u000e\u0005\u00055'\u0002BAh\u00037\n!![8\n\u0007%\u000bi\r\u0006\u0002\u0002:\u0006AAo\\*ue&tw\r\u0006\u0002\u0002T\u0005)\u0011\r\u001d9msR)Q+!8\u0002`\")1*\ba\u0001\u001b\")\u0011+\ba\u0001\u001b\u00069QO\\1qa2LH\u0003BAs\u0003c\u0004RAOAt\u0003WL1!!;<\u0005\u0019y\u0005\u000f^5p]B)!(!<N\u001b&\u0019\u0011q^\u001e\u0003\rQ+\b\u000f\\33\u0011!\t\u0019PHA\u0001\u0002\u0004)\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011 \t\u0005\u0003+\nY0\u0003\u0003\u0002~\u0006]#AB(cU\u0016\u001cG\u000f")
public class NaNvl
extends BinaryExpression
implements ConditionalExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl x$0) {
        return NaNvl$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contextIndependentFoldable()));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = this.left();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public NaNvl withNewAlwaysEvaluatedInputs(Seq<Expression> alwaysEvaluatedInputs) {
        return this.copy((Expression)alwaysEvaluatedInputs.head(), this.copy$default$2());
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        return new .colon.colon(this.children(), (List)Nil$.MODULE$);
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.left().eval(input);
        if (value == null) {
            return null;
        }
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            if (!Double.isNaN(BoxesRunTime.unboxToDouble((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            if (!Float.isNaN(BoxesRunTime.unboxToFloat((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ConditionalExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

