/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import org.apache.spark.sql.util.NumericHistogram;

public final class NumericHistogramSerializer$ {
    public static final NumericHistogramSerializer$ MODULE$ = new NumericHistogramSerializer$();

    private final int length(NumericHistogram histogram) {
        return 8 + histogram.getUsedBins() * 16;
    }

    public byte[] serialize(NumericHistogram histogram) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(histogram)]);
        buffer.putInt(histogram.getNumBins());
        buffer.putInt(histogram.getUsedBins());
        for (int i = 0; i < histogram.getUsedBins(); ++i) {
            NumericHistogram.Coord coord = histogram.getBin(i);
            buffer.putDouble(coord.x);
            buffer.putDouble(coord.y);
        }
        return buffer.array();
    }

    public NumericHistogram deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int nBins = buffer.getInt();
        int nUsedBins = buffer.getInt();
        NumericHistogram histogram = new NumericHistogram();
        histogram.allocate(nBins);
        histogram.setUsedBins(nUsedBins);
        for (int i = 0; i < nUsedBins; ++i) {
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            histogram.addBin(x, y, i);
        }
        return histogram;
    }

    private NumericHistogramSerializer$() {
    }
}

