/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.client.ConnectionPool;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.HttpClientTransport;
import org.sparkproject.jetty.util.Promise;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.component.ContainerLifeCycle;

@ManagedObject
public abstract class AbstractHttpClientTransport
extends ContainerLifeCycle
implements HttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private HttpClient client;
    private ConnectionPool.Factory factory;

    protected HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public ConnectionPool.Factory getConnectionPoolFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionPoolFactory(ConnectionPool.Factory factory) {
        this.factory = factory;
    }

    protected void connectFailed(Map<String, Object> context, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get("org.sparkproject.jetty.client.destination"));
        }
        Promise promise = (Promise)context.get("org.sparkproject.jetty.client.connection.promise");
        promise.failed(failure);
    }
}

