/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011K\u0011\u0015a\u0006\u0001\"\u0011K\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015i\u0007\u0001\"\u0011X\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\t\u0001\t#\n\u0019\u0003C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u0011Q\u0007\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0001\u0003oA\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA6\u0001\u0005\u0005I\u0011AA7\u0011%\t\u0019\bAA\u0001\n\u0003\n)\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#;\u0011\"!.#\u0003\u0003E\t!a.\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003sCa!U\u000e\u0005\u0002\u0005E\u0007\"CAj7\u0005\u0005IQIAk\u0011%\t9nGA\u0001\n\u0003\u000bI\u000eC\u0005\u0002`n\t\t\u0011\"!\u0002b\"I\u00111_\u000e\u0002\u0002\u0013%\u0011Q\u001f\u0002\r'R\u0014\u0018N\\4SKB,\u0017\r\u001e\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\r\u001b8{A\u0011\u0011GM\u0007\u0002E%\u00111G\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!M\u001b\n\u0005Y\u0012#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011aH\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014BA#:\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0015K\u0014aA:ueV\t1\n\u0005\u00022\u0019&\u0011QJ\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\nQ\u0001^5nKN\fa\u0001^5nKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"!\r\u0001\t\u000b%+\u0001\u0019A&\t\u000b=+\u0001\u0019A&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0001\f\u0005\u000293&\u0011!,\u000f\u0002\b\u0005>|G.Z1o\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u001a\nQ\u0001^=qKNL!\u0001Z1\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u00059\u0007c\u0001 iU&\u0011\u0011\u000e\u0013\u0002\u0004'\u0016\f\bC\u00011l\u0013\ta\u0017M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q2m\u001c8uKb$\u0018J\u001c3fa\u0016tG-\u001a8u\r>dG-\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001o];\u0011\u0005a\n\u0018B\u0001::\u0005\r\te.\u001f\u0005\u0006i2\u0001\r\u0001]\u0001\u0007gR\u0014\u0018N\\4\t\u000bYd\u0001\u0019\u00019\u0002\u00039\f!\u0002\u001d:fiRLh*Y7f+\u0005I\bC\u0001>\u007f\u001d\tYH\u0010\u0005\u0002As%\u0011Q0O\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{f\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u001d\u00111CA\u000f!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007E\u000591m\u001c3fO\u0016t\u0017\u0002BA\t\u0003\u0017\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003+q\u0001\u0019AA\f\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0013\tI\"\u0003\u0003\u0002\u001c\u0005-!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003?q\u0001\u0019AA\u0004\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)1+!\n\u0002*!1\u0011qE\bA\u0002-\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002,=\u0001\raS\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015\u0019\u0016\u0011GA\u001a\u0011\u001dI\u0005\u0003%AA\u0002-Cqa\u0014\t\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA&\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002He\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&\u0019q0a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004c\u0001\u001d\u0002h%\u0019\u0011\u0011N\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007A\fy\u0007C\u0005\u0002rU\t\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b\u0005e\u0014q\u00109\u000e\u0005\u0005m$bAA?s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002Y\u0003\u000fC\u0001\"!\u001d\u0018\u0003\u0003\u0005\r\u0001]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002T\u00055\u0005\"CA91\u0005\u0005\t\u0019AA3\u0003\u0019)\u0017/^1mgR\u0019\u0001,a%\t\u0011\u0005E\u0014$!AA\u0002AD3\u0003AAL\u0003;\u000by*a)\u0002&\u0006%\u00161VAX\u0003c\u00032!MAM\u0013\r\tYJ\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t+A)`\rVs5i\u0018\u0015tiJd\u0003E\\\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!gR\u0014\u0018N\\4!o\"L7\r\u001b\u0011sKB,\u0017\r^:!i\",\u0007eZ5wK:\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vK\u0002r\u0007\u0005^5nKNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0016\u0001\u0011\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u00124g\n\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001a4cI\u001a$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAZ\u00031\u0019HO]5oO~3WO\\2t\u00031\u0019FO]5oOJ+\u0007/Z1u!\t\t4dE\u0003\u001c\u0003w\u000b9\rE\u0004\u0002>\u0006\r7jS*\u000e\u0005\u0005}&bAAas\u00059!/\u001e8uS6,\u0017\u0002BAc\u0003\u007f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\tI-a4\u000e\u0005\u0005-'\u0002BAg\u00037\n!![8\n\u0007\u001d\u000bY\r\u0006\u0002\u00028\u0006AAo\\*ue&tw\r\u0006\u0002\u0002T\u0005)\u0011\r\u001d9msR)1+a7\u0002^\")\u0011J\ba\u0001\u0017\")qJ\ba\u0001\u0017\u00069QO\\1qa2LH\u0003BAr\u0003_\u0004R\u0001OAs\u0003SL1!a::\u0005\u0019y\u0005\u000f^5p]B)\u0001(a;L\u0017&\u0019\u0011Q^\u001d\u0003\rQ+\b\u000f\\33\u0011!\t\tpHA\u0001\u0002\u0004\u0019\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001f\t\u0005\u0003+\nI0\u0003\u0003\u0002|\u0006]#AB(cU\u0016\u001cG\u000f")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat x$0) {
        return StringRepeat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return super.contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(l, r) -> "(" + l + ").repeat(" + r + ")");
    }

    @Override
    public StringRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.times();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "times";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

