/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.RandStr$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(length[, seed]) - Returns a string of the specified length whose characters are chosen\n      uniformly at random from the following pool of characters: 0-9, a-z, A-Z. The random seed is\n      optional. The string length must be a constant two-byte or four-byte integer (SMALLINT or INT,\n      respectively).\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(3, 0) AS result;\n       ceV\n  ", since="4.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015f\u0001B\u00181\u0001vB\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005}!A\u0011\u000e\u0001BK\u0002\u0013\u0005s\r\u0003\u0005k\u0001\tE\t\u0015!\u0003?\u0011!Y\u0007A!f\u0001\n\u0003a\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011B7\t\u000bE\u0004A\u0011\u0001:\t\u000bE\u0004A\u0011A<\t\u000bE\u0004A\u0011A=\t\u000bq\u0004A\u0011\t7\t\u000bu\u0004A\u0011\t7\t\u000by\u0004A\u0011I4\t\u000b}\u0004A\u0011I4\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!Y\u0011q\u0003\u0001A\u0002\u0003\u0007I\u0011CA\r\u0011-\tY\u0003\u0001a\u0001\u0002\u0004%\t\"!\f\t\u0017\u0005e\u0002\u00011A\u0001B\u0003&\u00111\u0004\u0005\u000b\u0003\u0007\u0002\u0001R1A\u0005\u0012\u0005\u0015\u0003bBA(\u0001\u0011E\u0013\u0011\u000b\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001c\u0001\t\u0003\ny\u0007\u0003\u00046\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\tY\n\u0001C!\u0003;Cq!!-\u0001\t\u0013\t\u0019\fC\u0004\u00026\u0002!\t%a.\t\u0013\u0005M\u0007!!A\u0005\u0002\u0005U\u0007\"CAo\u0001E\u0005I\u0011AAp\u0011%\t)\u0010AI\u0001\n\u0003\ty\u000eC\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u001f\u0001\u0011\u0011!C\u0001\u0005#A\u0011Ba\u0005\u0001\u0003\u0003%\tA!\u0006\t\u0013\te\u0001!!A\u0005B\tm\u0001\"\u0003B\u0015\u0001\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011y\u0003AA\u0001\n\u0003\u0012\t\u0004C\u0005\u00036\u0001\t\t\u0011\"\u0011\u00038\u001d9!1\f\u0019\t\u0002\tucAB\u00181\u0011\u0003\u0011y\u0006\u0003\u0004rQ\u0011\u0005!\u0011\u000f\u0005\b\u0005gBC\u0011\u0001B;\u0011\u001d\u0011\u0019\b\u000bC\u0001\u0005sB\u0011Ba\u001d)\u0003\u0003%\tIa \t\u0013\t\u001d\u0005&!A\u0005\u0002\n%\u0005\"\u0003BNQ\u0005\u0005I\u0011\u0002BO\u0005\u001d\u0011\u0016M\u001c3TiJT!!\r\u001a\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003gQ\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003kY\n1a]9m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\n\n\u0001y\u0012Ui\u0013(R)j\u0003\"a\u0010!\u000e\u0003AJ!!\u0011\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002@\u0007&\u0011A\t\r\u0002\u0019\u000bb\u0004(/Z:tS>tw+\u001b;i%\u0006tGm\\7TK\u0016$\u0007c\u0001$J}5\tqI\u0003\u0002Ie\u0005)AO]3fg&\u0011!j\u0012\u0002\u000b\u0005&t\u0017M]=MS.,\u0007CA M\u0013\ti\u0005G\u0001\u0011EK\u001a\fW\u000f\u001c;TiJLgn\u001a)s_\u0012,8-\u001b8h\u000bb\u0004(/Z:tS>t\u0007CA P\u0013\t\u0001\u0006G\u0001\tO_:$W\r^3s[&t\u0017n\u001d;jGB\u0011qHU\u0005\u0003'B\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u001d\u0001&o\u001c3vGR\u0004\"aW2\u000f\u0005q\u000bgBA/a\u001b\u0005q&BA0=\u0003\u0019a$o\\8u}%\tq+\u0003\u0002c-\u00069\u0001/Y2lC\u001e,\u0017B\u00013f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0011g+\u0001\u0004mK:<G\u000f[\u000b\u0002}\u00059A.\u001a8hi\"\u0004\u0013AD:fK\u0012,\u0005\u0010\u001d:fgNLwN\\\u0001\u0010g\u0016,G-\u0012=qe\u0016\u001c8/[8oA\u0005A\u0001.\u001b3f'\u0016,G-F\u0001n!\t)f.\u0003\u0002p-\n9!i\\8mK\u0006t\u0017!\u00035jI\u0016\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q!1\u000f^;w!\ty\u0004\u0001C\u0003g\u000f\u0001\u0007a\bC\u0003j\u000f\u0001\u0007a\bC\u0003l\u000f\u0001\u0007Q\u000e\u0006\u0002tq\")a\r\u0003a\u0001}Q\u00191O_>\t\u000b\u0019L\u0001\u0019\u0001 \t\u000b%L\u0001\u0019\u0001 \u0002\u00119,H\u000e\\1cY\u0016\f\u0001b\u001d;bi\u00164W\u000f\\\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0002\u0011\u000bm\u000b9!a\u0003\n\u0007\u0005%QMA\u0002TKF\u0004B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#!\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0007Itw-\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012A\u0002:b]\u0012|WNC\u0002\u0002&Y\nA!\u001e;jY&!\u0011\u0011FA\u0010\u00059AvJU*iS\u001a$(+\u00198e_6\fqA\u001d8h?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005U\u0002cA+\u00022%\u0019\u00111\u0007,\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003o\u0001\u0012\u0011!a\u0001\u00037\t1\u0001\u001f\u00132\u0003\u0011\u0011hn\u001a\u0011)\u0007E\ti\u0004E\u0002V\u0003\u007fI1!!\u0011W\u0005%!(/\u00198tS\u0016tG/\u0001\u0003tK\u0016$WCAA$!\r)\u0016\u0011J\u0005\u0004\u0003\u00172&\u0001\u0002'p]\u001eD3AEA\u001f\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\t\u0005=\u00121\u000b\u0005\b\u0003+\u001a\u0002\u0019AA,\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042!VA-\u0013\r\tYF\u0016\u0002\u0004\u0013:$\u0018aC<ji\"tUm^*fK\u0012$2APA1\u0011\u001d\t\u0019\u0007\u0006a\u0001\u0003\u000f\nqA\\3x'\u0016,G-A\bxSRD7\u000b[5gi\u0016$7+Z3e)\rq\u0014\u0011\u000e\u0005\b\u0003W*\u0002\u0019AA$\u0003\u0015\u0019\b.\u001b4u\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003?\u0003c\n)\b\u0003\u0004\u0002tY\u0001\rAP\u0001\t]\u0016<h)\u001b:ti\"1\u0011q\u000f\fA\u0002y\n\u0011B\\3x'\u0016\u001cwN\u001c3\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u000bsA!a \u0002\u0002B\u0011QLV\u0005\u0004\u0003\u00073\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0006%%AB*ue&twMC\u0002\u0002\u0004Z\u000b1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a$\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&3\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAM\u0003'\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\rKZ\fG.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003?\u000b)\u000bE\u0002V\u0003CK1!a)W\u0005\r\te.\u001f\u0005\b\u0003OK\u0002\u0019AAU\u0003\u0015Ig\u000e];u!\u0011\tY+!,\u000e\u0003IJ1!a,3\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u001b1,gn\u001a;i\u0013:$XmZ3s)\t\t9&A\u0005e_\u001e+gnQ8eKR1\u0011\u0011XAc\u0003\u001f\u0004B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f\u0003\u0014aB2pI\u0016<WM\\\u0005\u0005\u0003\u0007\fiL\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9m\u0007a\u0001\u0003\u0013\f1a\u0019;y!\u0011\tY,a3\n\t\u00055\u0017Q\u0018\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\tn\u0007a\u0001\u0003s\u000b!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\bg\u0006]\u0017\u0011\\An\u0011\u001d1G\u0004%AA\u0002yBq!\u001b\u000f\u0011\u0002\u0003\u0007a\bC\u0004l9A\u0005\t\u0019A7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001d\u0016\u0004}\u0005\r8FAAs!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=h+\u0001\u0006b]:|G/\u0019;j_:LA!a=\u0002j\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA~U\ri\u00171]\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\u0005Y\u0006twM\u0003\u0002\u0003\f\u0005!!.\u0019<b\u0013\u0011\t9I!\u0002\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003?\u00139\u0002C\u0005\u00028\t\n\t\u00111\u0001\u0002X\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001eA1!q\u0004B\u0013\u0003?k!A!\t\u000b\u0007\t\rb+\u0001\u0006d_2dWm\u0019;j_:LAAa\n\u0003\"\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri'Q\u0006\u0005\n\u0003o!\u0013\u0011!a\u0001\u0003?\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0001B\u001a\u0011%\t9$JA\u0001\u0002\u0004\t9&\u0001\u0004fcV\fGn\u001d\u000b\u0004[\ne\u0002\"CA\u001cM\u0005\u0005\t\u0019AAPQM\u0001!Q\bB\"\u0005\u000b\u0012IEa\u0013\u0003P\tE#Q\u000bB,!\ry$qH\u0005\u0004\u0005\u0003\u0002$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005\u000f\n!Q\u0011\u0006!A\u0001\u0002sLR+O\u0007~CC.\u001a8hi\"\\F\u0006I:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:j]\u001e\u0004sN\u001a\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011mK:<G\u000f\u001b\u0011xQ>\u001cX\rI2iCJ\f7\r^3sg\u0002\n'/\u001a\u0011dQ>\u001cXM\u001c\u0006!A\u0001\u0002\u0003\u0005I;oS\u001a|'/\u001c7zA\u0005$\bE]1oI>l\u0007E\u001a:p[\u0002\"\b.\u001a\u0011g_2dwn^5oO\u0002\u0002xn\u001c7!_\u001a\u00043\r[1sC\u000e$XM]:;AAj\u0013\b\f\u0011b[id\u0003%Q\u0017[]\u0001\"\u0006.\u001a\u0011sC:$w.\u001c\u0011tK\u0016$\u0007%[:\u000bA\u0001\u0002\u0003\u0005\t\u0011paRLwN\\1m]\u0001\"\u0006.\u001a\u0011tiJLgn\u001a\u0011mK:<G\u000f\u001b\u0011nkN$\bEY3!C\u0002\u001awN\\:uC:$\b\u0005^<p[\tLH/\u001a\u0011pe\u00022w.\u001e:.Ef$X\rI5oi\u0016<WM\u001d\u0011)'6\u000bE\nT%O)\u0002z'\u000fI%O)2R\u0001\u0005\t\u0011!A\u0001\u0012Xm\u001d9fGRLg/\u001a7zS9R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QJ\u0001D\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aD\u0006\t\u0019*A\u0005\u001b\u0006E]3tk2$8H\u0003\u0011!A\u0001\u0002\u0003\u0005I2f-*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003T\u0005)AG\f\u0019/a\u0005)qM]8va\u0006\u0012!\u0011L\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\b%\u0006tGm\u0015;s!\ty\u0004fE\u0003)\u0005C\u00129\u0007E\u0002V\u0005GJ1A!\u001aW\u0005\u0019\te.\u001f*fMB!!\u0011\u000eB8\u001b\t\u0011YG\u0003\u0003\u0003n\t%\u0011AA5p\u0013\r!'1\u000e\u000b\u0003\u0005;\nQ!\u00199qYf$2a\u001dB<\u0011\u00151'\u00061\u0001?)\u0015\u0019(1\u0010B?\u0011\u001517\u00061\u0001?\u0011\u0015I7\u00061\u0001?)\u001d\u0019(\u0011\u0011BB\u0005\u000bCQA\u001a\u0017A\u0002yBQ!\u001b\u0017A\u0002yBQa\u001b\u0017A\u00025\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\f\n]\u0005#B+\u0003\u000e\nE\u0015b\u0001BH-\n1q\n\u001d;j_:\u0004b!\u0016BJ}yj\u0017b\u0001BK-\n1A+\u001e9mKNB\u0001B!'.\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BP!\u0011\u0011\u0019A!)\n\t\t\r&Q\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class RandStr
extends Expression
implements ExpressionWithRandomSeed,
BinaryLike<Expression>,
DefaultStringProducingExpression,
Nondeterministic,
ExpectsInputTypes,
Serializable {
    private transient long seed;
    private final Expression length;
    private final Expression seedExpression;
    private final boolean hideSeed;
    private transient XORShiftRandom rng;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(RandStr x$0) {
        return RandStr$.MODULE$.unapply(x$0);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private boolean deterministic$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression length() {
        return this.length;
    }

    @Override
    public Expression seedExpression() {
        return this.seedExpression;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression left() {
        return this.length();
    }

    @Override
    public Expression right() {
        return this.seedExpression();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$})), (List)Nil$.MODULE$));
    }

    public XORShiftRandom rng() {
        return this.rng;
    }

    public void rng_$eq(XORShiftRandom x$1) {
        this.rng = x$1;
    }

    private long seed$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                long l;
                Expression expression = this.seedExpression();
                DataType dataType = expression.dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(integerType$) : integerType$ != null)) {
                    l = BoxesRunTime.unboxToInt((Object)expression.eval(expression.eval$default$1()));
                } else {
                    DataType dataType2 = expression.dataType();
                    LongType$ longType$ = LongType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(longType$) : longType$ != null)) {
                        l = BoxesRunTime.unboxToLong((Object)expression.eval(expression.eval$default$1()));
                    } else {
                        throw new MatchError((Object)expression);
                    }
                }
                this.seed = l;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.seed;
    }

    public long seed() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.seed$lzycompute();
        }
        return this.seed;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.rng_$eq(new XORShiftRandom(this.seed() + (long)partitionIndex));
    }

    @Override
    public Expression withNewSeed(long newSeed) {
        return new RandStr(this.length(), new Literal(BoxesRunTime.boxToLong((long)newSeed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withShiftedSeed(long shift) {
        return new RandStr(this.length(), new Literal(BoxesRunTime.boxToLong((long)(this.seed() + shift)), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond) {
        return new RandStr(newFirst, newSecond, this.hideSeed());
    }

    @Override
    public String sql() {
        return "randstr(" + this.length().sql() + (this.hideSeed() ? "" : ", " + this.seedExpression().sql()) + ")";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ObjectRef result = ObjectRef.create((Object)ExpectsInputTypes.checkInputDataTypes$(this));
        new .colon.colon((Object)new Tuple2((Object)this.length(), (Object)"length"), (List)new .colon.colon((Object)new Tuple2((Object)this.seedExpression(), (Object)"seed"), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            RandStr.$anonfun$checkInputDataTypes$2(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (TypeCheckResult)result.elem;
    }

    @Override
    public Object evalInternal(InternalRow input) {
        int numChars = this.lengthInteger();
        return ExpressionImplUtils.randStr(this.rng(), numChars);
    }

    private int lengthInteger() {
        DataType dataType = this.length().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), (Function0 & Serializable)() -> "Expected IntegerType, got " + this.length().dataType());
        int result = BoxesRunTime.unboxToInt((Object)this.length().eval(this.length().eval$default$1()));
        if (result < 0) {
            throw QueryExecutionErrors$.MODULE$.unexpectedValueForLengthInFunctionError(this.prettyName(), result);
        }
        return result;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(rngTerm + " = new " + className + "(" + this.seed() + "L + partitionIndex);");
        int numChars = this.lengthInteger();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |UTF8String ", " =\n        |  ", ".randStr(", ", ", ");\n        |boolean ", " = false;\n        |"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ExpressionImplUtils.class.getName(), rngTerm, BoxesRunTime.boxToInteger((int)numChars), ev.isNull()})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public RandStr copy(Expression length, Expression seedExpression, boolean hideSeed) {
        return new RandStr(length, seedExpression, hideSeed);
    }

    public Expression copy$default$1() {
        return this.length();
    }

    public Expression copy$default$2() {
        return this.seedExpression();
    }

    public boolean copy$default$3() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "RandStr";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.length();
            }
            case 1: {
                return this.seedExpression();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RandStr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "length";
            }
            case 1: {
                return "seedExpression";
            }
            case 2: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RandStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RandStr randStr = (RandStr)x$1;
        if (this.hideSeed() != randStr.hideSeed()) return false;
        Expression expression = this.length();
        Expression expression2 = randStr.length();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.seedExpression();
        Expression expression4 = randStr.seedExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!randStr.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$checkInputDataTypes$2(ObjectRef result$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression expr = (Expression)tuple2._1();
            String name = (String)tuple2._2();
            if (expr != null) {
                Expression expression = expr;
                if (name != null) {
                    String string = name;
                    TypeCheckResult typeCheckResult = (TypeCheckResult)result$2.elem;
                    TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    if (!(typeCheckResult != null ? !typeCheckResult.equals(typeCheckResult$TypeCheckSuccess$) : typeCheckResult$TypeCheckSuccess$ != null) && !expression.foldable()) {
                        result$2.elem = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)ExpectsInputTypes$.MODULE$.toSQLId(string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"integer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)ExpectsInputTypes$.MODULE$.toSQLExpr(expression))}))));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public RandStr(Expression length, Expression seedExpression, boolean hideSeed) {
        this.length = length;
        this.seedExpression = seedExpression;
        this.hideSeed = hideSeed;
        ExpressionWithRandomSeed.$init$(this);
        BinaryLike.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Nondeterministic.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public RandStr(Expression length) {
        this(length, UnresolvedSeed$.MODULE$, true);
    }

    public RandStr(Expression length, Expression seedExpression) {
        this(length, seedExpression, false);
    }
}

