/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.shared.common.error.StandardException;

class CoalesceFunctionNode
extends ValueNode {
    String functionName;
    ValueNodeList argumentsList;
    private int firstNonParameterNodeIdx = -1;

    CoalesceFunctionNode(String string, ValueNodeList valueNodeList, ContextManager contextManager) {
        super(contextManager);
        this.functionName = string;
        this.argumentsList = valueNodeList;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.argumentsList.bindExpression(fromList, subqueryList, list);
        if (this.argumentsList.size() < 2) {
            throw StandardException.newException((String)"42605", (Object[])new Object[]{this.functionName});
        }
        if (this.argumentsList.containsAllParameterNodes()) {
            throw StandardException.newException((String)"42610", (Object[])new Object[0]);
        }
        int n = this.argumentsList.size();
        for (int i = 0; i < n; ++i) {
            if (((ValueNode)this.argumentsList.elementAt(i)).requiresTypeFromContext()) continue;
            this.firstNonParameterNodeIdx = i;
            break;
        }
        for (ValueNode valueNode : this.argumentsList) {
            if (valueNode.requiresTypeFromContext()) continue;
            this.argumentsList.compatible(valueNode);
        }
        this.setType(this.argumentsList.getDominantTypeServices());
        for (ValueNode valueNode : this.argumentsList) {
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(this.getTypeServices());
        }
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.argumentsList.size();
        String string = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string2 = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", n);
        methodBuilder2.setField(localField);
        int n2 = 0;
        MethodBuilder methodBuilder3 = null;
        MethodBuilder methodBuilder4 = methodBuilder2;
        for (int i = 0; i < n; ++i) {
            MethodBuilder methodBuilder5;
            if (this.argumentsList.elementAt(i) instanceof ConstantNode) {
                ++n2;
                if (methodBuilder4.statementNumHitLimit(1)) {
                    MethodBuilder methodBuilder6 = expressionClassBuilder.newGeneratedFun("void", 2);
                    methodBuilder4.pushThis();
                    methodBuilder4.callMethod((short)182, null, methodBuilder6.getName(), "void", 0);
                    if (methodBuilder4 != methodBuilder2) {
                        methodBuilder4.methodReturn();
                        methodBuilder4.complete();
                    }
                    methodBuilder4 = methodBuilder6;
                }
                methodBuilder5 = methodBuilder4;
            } else {
                if (methodBuilder3 == null) {
                    methodBuilder3 = expressionClassBuilder.newGeneratedFun("void", 4);
                }
                methodBuilder5 = methodBuilder3;
            }
            methodBuilder5.getField(localField);
            ((ValueNode)this.argumentsList.elementAt(i)).generateExpression(expressionClassBuilder, methodBuilder5);
            methodBuilder5.upCast(string);
            methodBuilder5.setArrayElement(i);
        }
        if (methodBuilder4 != methodBuilder2) {
            methodBuilder4.methodReturn();
            methodBuilder4.complete();
        }
        if (methodBuilder3 != null) {
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder3.getName(), "void", 0);
        }
        ((ValueNode)this.argumentsList.elementAt(this.firstNonParameterNodeIdx)).generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.getField(localField);
        LocalField localField2 = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.putField(localField2);
        methodBuilder.callMethod((short)185, string, "coalesce", string, 2);
        if (this.getTypeId().variableLength()) {
            boolean bl = this.getTypeId().isNumericTypeId();
            methodBuilder.dup();
            methodBuilder.push(bl ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            methodBuilder.push(this.getTypeServices().getScale());
            methodBuilder.push(true);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeKind(valueNode)) {
            return false;
        }
        CoalesceFunctionNode coalesceFunctionNode = (CoalesceFunctionNode)valueNode;
        return this.argumentsList.isEquivalent(coalesceFunctionNode.argumentsList);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        this.argumentsList = (ValueNodeList)this.argumentsList.accept(visitor);
    }

    @Override
    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.argumentsList.categorize(jBitSet, bl);
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.argumentsList.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.argumentsList = this.argumentsList.remapColumnReferencesToExpressions();
        return this;
    }
}

