/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.networktopography.AbstractDNSToSwitchMapping;

public final class AlternateRackDNSToSwitchMapping
extends AbstractDNSToSwitchMapping {
    private Map<String, String> mappingCache = new ConcurrentHashMap<String, String>();

    @Override
    public Map<String, String> resolve(List<String> names) {
        TreeSet<String> sortedNames = new TreeSet<String>(names);
        HashMap<String, String> m = new HashMap<String, String>();
        if (names.isEmpty()) {
            return m;
        }
        Boolean odd = true;
        for (String name : sortedNames) {
            if (odd.booleanValue()) {
                m.put(name, "RACK1");
                this.mappingCache.put(name, "RACK1");
                odd = false;
                continue;
            }
            m.put(name, "RACK2");
            this.mappingCache.put(name, "RACK2");
            odd = true;
        }
        return m;
    }

    public String toString() {
        return "defaultRackDNSToSwitchMapping (" + this.mappingCache.size() + " mappings cached)";
    }
}

