/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system;

final class CallOrigin {
    private final boolean printingStackTrace;
    private final String className;

    private CallOrigin(boolean isStacktrace, String className) {
        this.printingStackTrace = isStacktrace;
        this.className = className;
    }

    boolean isPrintingStackTrace() {
        return this.printingStackTrace;
    }

    String getClassName() {
        return this.className;
    }

    static CallOrigin getCallOrigin(StackTraceElement[] stackTraceElements, String libraryPackageName) {
        boolean isStackTrace = false;
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String className = stackTraceElement.getClassName();
            if (className.equals(Throwable.class.getName())) {
                isStackTrace = true;
            } else if (CallOrigin.outsideThisLibrary(className, libraryPackageName)) {
                className = CallOrigin.getOuterClassName(className);
                return new CallOrigin(isStackTrace, className);
            }
            ++n2;
        }
        throw new IllegalStateException("Nothing in the stack originated from outside package name " + libraryPackageName);
    }

    private static boolean outsideThisLibrary(String className, String libraryPackageName) {
        return !className.equals(Thread.class.getName()) && !className.startsWith(libraryPackageName);
    }

    private static String getOuterClassName(String className) {
        int startOfInnerClassName = className.indexOf(36);
        String outerClassName = startOfInnerClassName == -1 ? className : className.substring(0, startOfInnerClassName);
        return outerClassName;
    }
}

