/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

public class BufferOrEvent {
    private final Buffer buffer;
    private final AbstractEvent event;
    private final boolean hasPriority;
    private boolean moreAvailable;
    private final boolean morePriorityEvents;
    private InputChannelInfo channelInfo;
    private final int size;

    public BufferOrEvent(Buffer buffer, InputChannelInfo channelInfo, boolean moreAvailable, boolean morePriorityEvents) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.hasPriority = false;
        this.event = null;
        this.channelInfo = channelInfo;
        this.moreAvailable = moreAvailable;
        this.size = buffer.getSize();
        this.morePriorityEvents = morePriorityEvents;
    }

    public BufferOrEvent(AbstractEvent event, boolean hasPriority, InputChannelInfo channelInfo, boolean moreAvailable, int size, boolean morePriorityEvents) {
        this.buffer = null;
        this.hasPriority = hasPriority;
        this.event = (AbstractEvent)Preconditions.checkNotNull((Object)event);
        this.channelInfo = channelInfo;
        this.moreAvailable = moreAvailable;
        this.size = size;
        this.morePriorityEvents = morePriorityEvents;
    }

    @VisibleForTesting
    public BufferOrEvent(Buffer buffer, InputChannelInfo channelInfo) {
        this(buffer, channelInfo, true, false);
    }

    @VisibleForTesting
    public BufferOrEvent(AbstractEvent event, InputChannelInfo channelInfo) {
        this(event, false, channelInfo, true, 0, false);
    }

    public boolean isBuffer() {
        return this.buffer != null;
    }

    public boolean isEvent() {
        return this.event != null;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public AbstractEvent getEvent() {
        return this.event;
    }

    public InputChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public void setChannelInfo(InputChannelInfo channelInfo) {
        this.channelInfo = channelInfo;
    }

    public boolean moreAvailable() {
        return this.moreAvailable;
    }

    public boolean morePriorityEvents() {
        return this.morePriorityEvents;
    }

    public String toString() {
        return String.format("BufferOrEvent [%s, channelInfo = %s, size = %d]", this.isBuffer() ? this.buffer : this.event + " (prio=" + this.hasPriority + ")", this.channelInfo, this.size);
    }

    public void setMoreAvailable(boolean moreAvailable) {
        this.moreAvailable = moreAvailable;
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasPriority() {
        return this.hasPriority;
    }
}

