/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.enums.ClusterState;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.mapper.FlinkClusterMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.service.SettingService;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.apache.streampark.flink.client.FlinkClient;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.KubernetesDeployRequest;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class FlinkClusterServiceImpl
extends ServiceImpl<FlinkClusterMapper, FlinkCluster>
implements FlinkClusterService {
    private static final Logger log = LoggerFactory.getLogger(FlinkClusterServiceImpl.class);
    private static final String ERROR_CLUSTER_QUEUE_HINT = "Queue label '%s' isn't available in database, please add it first.";
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private YarnQueueService yarnQueueService;
    @Autowired
    private SettingService settingService;
    private static final int CPU_NUM = Math.max(4, Runtime.getRuntime().availableProcessors() * 2);
    private final ExecutorService bootstrapExecutor = new ThreadPoolExecutor(1, CPU_NUM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-cluster-bootstrap"));

    @Override
    public ResponseResult check(FlinkCluster cluster) {
        Boolean existsByClusterId;
        ResponseResult result = new ResponseResult();
        result.setStatus(0);
        Boolean existsByClusterName = this.existsByClusterName(cluster.getClusterName(), cluster.getId());
        if (existsByClusterName.booleanValue()) {
            result.setMsg("clusterName is already exists,please check!");
            result.setStatus(1);
            return result;
        }
        String clusterId = cluster.getClusterId();
        if (StringUtils.isNotEmpty((CharSequence)clusterId) && (existsByClusterId = this.existsByClusterId(clusterId, cluster.getId())).booleanValue()) {
            result.setMsg("the clusterId " + clusterId + " is already exists,please check!");
            result.setStatus(2);
            return result;
        }
        if (ExecutionMode.REMOTE.equals((Object)cluster.getExecutionModeEnum())) {
            if (!cluster.verifyClusterConnection()) {
                result.setMsg("the remote cluster connection failed, please check!");
                result.setStatus(3);
                return result;
            }
        } else if (ExecutionMode.YARN_SESSION.equals((Object)cluster.getExecutionModeEnum()) && cluster.getClusterId() != null && !cluster.verifyClusterConnection()) {
            result.setMsg("the flink cluster connection failed, please check!");
            result.setStatus(4);
            return result;
        }
        return result;
    }

    @Override
    public Boolean create(FlinkCluster flinkCluster, Long userId) {
        flinkCluster.setUserId(userId);
        boolean successful = this.validateQueueIfNeeded(flinkCluster);
        ApiAlertException.throwIfFalse(successful, String.format(ERROR_CLUSTER_QUEUE_HINT, flinkCluster.getYarnQueue()));
        flinkCluster.setCreateTime(new Date());
        if (ExecutionMode.REMOTE.equals((Object)flinkCluster.getExecutionModeEnum())) {
            flinkCluster.setClusterState(ClusterState.STARTED.getValue());
        } else {
            flinkCluster.setClusterState(ClusterState.CREATED.getValue());
        }
        return this.save(flinkCluster);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start(Long id) {
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(id);
        ApiAlertException.throwIfTrue(flinkCluster == null, "Invalid id, no related cluster found.");
        ExecutionMode executionModeEnum = flinkCluster.getExecutionModeEnum();
        if (executionModeEnum == ExecutionMode.YARN_SESSION) {
            ApiAlertException.throwIfTrue(!this.applicationService.getYARNApplication(flinkCluster.getClusterName()).isEmpty(), "The application name: " + flinkCluster.getClusterName() + " is already running in the yarn queue, please check!");
        }
        try {
            DeployRequest deployRequest = this.getDeployRequest(flinkCluster);
            log.info("deploy cluster request: {}", (Object)deployRequest);
            Future<DeployResponse> future = this.bootstrapExecutor.submit(() -> FlinkClient.deploy((DeployRequest)deployRequest));
            DeployResponse deployResponse = future.get();
            if (deployResponse.error() != null) {
                throw new ApiDetailException("deploy cluster " + flinkCluster.getClusterName() + "failed, exception:\n" + Utils.stringifyException((Throwable)deployResponse.error()));
            }
            if (ExecutionMode.YARN_SESSION.equals((Object)executionModeEnum)) {
                String address = YarnUtils.getRMWebAppProxyURL() + "/proxy/" + deployResponse.clusterId() + "/";
                flinkCluster.setAddress(address);
            } else {
                flinkCluster.setAddress(deployResponse.address());
            }
            flinkCluster.setClusterId(deployResponse.clusterId());
            flinkCluster.setClusterState(ClusterState.STARTED.getValue());
            flinkCluster.setException(null);
            this.updateById(flinkCluster);
            if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals((Object)executionModeEnum)) {
                try {
                    this.serviceHelper.configureIngress(flinkCluster.getClusterId(), flinkCluster.getK8sNamespace());
                }
                catch (KubernetesClientException e) {
                    log.info("Failed to create ingress: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            flinkCluster.setClusterState(ClusterState.STOPPED.getValue());
            flinkCluster.setException(e.toString());
            this.updateById(flinkCluster);
            throw new ApiDetailException(e);
        }
    }

    private DeployRequest getDeployRequest(FlinkCluster flinkCluster) {
        ExecutionMode executionModeEnum = flinkCluster.getExecutionModeEnum();
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(flinkCluster.getVersionId());
        switch (executionModeEnum) {
            case YARN_SESSION: {
                return DeployRequest.apply((FlinkVersion)flinkEnv.getFlinkVersion(), (ExecutionMode)executionModeEnum, flinkCluster.getProperties(), (String)flinkCluster.getClusterId(), (String)flinkCluster.getClusterName());
            }
            case KUBERNETES_NATIVE_SESSION: {
                return KubernetesDeployRequest.apply((FlinkVersion)flinkEnv.getFlinkVersion(), (ExecutionMode)executionModeEnum, flinkCluster.getProperties(), (String)flinkCluster.getClusterId(), (String)flinkCluster.getClusterName(), (String)flinkCluster.getK8sNamespace(), (String)flinkCluster.getK8sConf(), (String)flinkCluster.getServiceAccount(), (String)flinkCluster.getFlinkImage(), (FlinkK8sRestExposedType)flinkCluster.getK8sRestExposedTypeEnum());
            }
        }
        throw new ApiAlertException("the ExecutionModeEnum " + executionModeEnum.getName() + "can't start!");
    }

    @Override
    public void update(FlinkCluster cluster) {
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(cluster.getId());
        boolean success = this.validateQueueIfNeeded(flinkCluster, cluster);
        ApiAlertException.throwIfFalse(success, String.format(ERROR_CLUSTER_QUEUE_HINT, cluster.getYarnQueue()));
        flinkCluster.setClusterName(cluster.getClusterName());
        flinkCluster.setDescription(cluster.getDescription());
        if (ExecutionMode.REMOTE.equals((Object)flinkCluster.getExecutionModeEnum())) {
            flinkCluster.setAddress(cluster.getAddress());
        } else {
            flinkCluster.setAddress(null);
            flinkCluster.setClusterId(cluster.getClusterId());
            flinkCluster.setVersionId(cluster.getVersionId());
            flinkCluster.setDynamicProperties(cluster.getDynamicProperties());
            flinkCluster.setOptions(cluster.getOptions());
            flinkCluster.setResolveOrder(cluster.getResolveOrder());
            flinkCluster.setK8sHadoopIntegration(cluster.getK8sHadoopIntegration());
            flinkCluster.setK8sConf(cluster.getK8sConf());
            flinkCluster.setK8sNamespace(cluster.getK8sNamespace());
            flinkCluster.setK8sRestExposedType(cluster.getK8sRestExposedType());
            flinkCluster.setServiceAccount(cluster.getServiceAccount());
            flinkCluster.setFlinkImage(cluster.getFlinkImage());
            flinkCluster.setYarnQueue(cluster.getYarnQueue());
        }
        try {
            this.updateById(flinkCluster);
        }
        catch (Exception e) {
            throw new ApiDetailException("update cluster failed, Caused By: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void shutdown(Long id) {
        boolean existsRunningJob;
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(id);
        ExecutionMode executionModeEnum = flinkCluster.getExecutionModeEnum();
        String clusterId = flinkCluster.getClusterId();
        if (StringUtils.isBlank((CharSequence)clusterId)) {
            throw new ApiAlertException("the clusterId can not be empty!");
        }
        if (ExecutionMode.YARN_SESSION.equals((Object)executionModeEnum)) {
            if (ClusterState.STARTED.equals((Object)ClusterState.of((Integer)flinkCluster.getClusterState()))) {
                if (!flinkCluster.verifyClusterConnection()) {
                    flinkCluster.setAddress(null);
                    flinkCluster.setClusterState(ClusterState.LOST.getValue());
                    this.updateById(flinkCluster);
                    throw new ApiAlertException("current cluster is not active, please check");
                }
            } else {
                throw new ApiAlertException("current cluster is not active, please check");
            }
        }
        if (existsRunningJob = this.applicationService.existsRunningJobByClusterId(flinkCluster.getId())) {
            throw new ApiAlertException("There are some jobs running on the cluster, so the cluster cannot be shut down. \ud83d\ude14\n\n");
        }
        DeployRequest deployRequest = this.getDeployRequest(flinkCluster);
        try {
            Future<ShutDownResponse> future = this.bootstrapExecutor.submit(() -> FlinkClient.shutdown((DeployRequest)deployRequest));
            ShutDownResponse shutDownResponse = future.get();
            if (shutDownResponse.error() != null) {
                throw new ApiDetailException("shutdown cluster failed, error: \n" + Utils.stringifyException((Throwable)shutDownResponse.error()));
            }
            flinkCluster.setAddress(null);
            flinkCluster.setClusterState(ClusterState.STOPPED.getValue());
            this.updateById(flinkCluster);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            flinkCluster.setException(e.toString());
            this.updateById(flinkCluster);
            throw new ApiDetailException("shutdown cluster failed, Caused By: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public Boolean existsByClusterId(String clusterId, Long id) {
        return ((FlinkClusterMapper)this.baseMapper).existsByClusterId(clusterId, id);
    }

    @Override
    public Boolean existsByClusterName(String clusterName, Long id) {
        return ((FlinkClusterMapper)this.baseMapper).existsByClusterName(clusterName, id);
    }

    @Override
    public Boolean existsByFlinkEnvId(Long flinkEnvId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkCluster::getVersionId, (Object)flinkEnvId);
        return ((FlinkClusterMapper)this.getBaseMapper()).exists((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<FlinkCluster> getByExecutionModes(Collection<ExecutionMode> executionModes) {
        return ((FlinkClusterMapper)this.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().in(FlinkCluster::getExecutionMode, (Collection)executionModes.stream().map(ExecutionMode::getMode).collect(Collectors.toSet())));
    }

    @Override
    public List<FlinkCluster> listCluster() {
        List clusters = this.list();
        for (FlinkCluster cluster : clusters) {
            String clusterId;
            String namespace;
            String ingressUrl;
            if (!ExecutionMode.KUBERNETES_NATIVE_SESSION.equals((Object)cluster.getExecutionModeEnum()) || !StringUtils.isNotBlank((CharSequence)this.settingService.getIngressModeDefault()) || (ingressUrl = KubernetesRetriever.getSessionClusterIngressURL((String)(namespace = cluster.getK8sNamespace()), (String)(clusterId = cluster.getClusterId()))) == null) continue;
            cluster.setAddress(ingressUrl);
        }
        return clusters;
    }

    @Override
    public IPage<FlinkCluster> findPage(FlinkCluster flinkCluster, RestRequest restRequest) {
        Page page = MybatisPager.getPage(restRequest);
        return ((FlinkClusterMapper)this.baseMapper).findPage(page, flinkCluster);
    }

    @Override
    public void delete(Long id) {
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(id);
        if (flinkCluster == null) {
            throw new ApiAlertException("flink cluster not exist, please check.");
        }
        if ((ExecutionMode.YARN_SESSION.equals((Object)flinkCluster.getExecutionModeEnum()) || ExecutionMode.KUBERNETES_NATIVE_SESSION.equals((Object)flinkCluster.getExecutionModeEnum())) && ClusterState.STARTED.equals((Object)flinkCluster.getClusterStateEnum())) {
            throw new ApiAlertException("flink cluster is running, cannot be delete, please check.");
        }
        if (this.applicationService.existsJobByClusterId(id)) {
            throw new ApiAlertException("some app on this cluster, the cluster cannot be delete, please check.");
        }
        this.removeById(id);
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(FlinkCluster clusterInfo) {
        this.yarnQueueService.checkQueueLabel(clusterInfo.getExecutionModeEnum(), clusterInfo.getYarnQueue());
        if (!this.isYarnNotDefaultQueue(clusterInfo)) {
            return true;
        }
        return this.yarnQueueService.existByQueueLabel(clusterInfo.getYarnQueue());
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(FlinkCluster oldCluster, FlinkCluster newCluster) {
        this.yarnQueueService.checkQueueLabel(newCluster.getExecutionModeEnum(), newCluster.getYarnQueue());
        if (!this.isYarnNotDefaultQueue(newCluster)) {
            return true;
        }
        if (ExecutionMode.isYarnSessionMode((ExecutionMode)newCluster.getExecutionModeEnum()) && StringUtils.equals((CharSequence)oldCluster.getYarnQueue(), (CharSequence)newCluster.getYarnQueue())) {
            return true;
        }
        return this.yarnQueueService.existByQueueLabel(newCluster.getYarnQueue());
    }

    private boolean isYarnNotDefaultQueue(FlinkCluster cluster) {
        return ExecutionMode.isYarnSessionMode((ExecutionMode)cluster.getExecutionModeEnum()) && !this.yarnQueueService.isDefaultQueue(cluster.getYarnQueue());
    }
}

