/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedModifyDNRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedModifyDNResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedModifyDNOperation
extends InterceptedOperation
implements InMemoryInterceptedModifyDNRequest,
InMemoryInterceptedModifyDNResult {
    @NotNull
    private ModifyDNRequest modifyDNRequest;
    @Nullable
    private LDAPResult modifyDNResult;

    InterceptedModifyDNOperation(@NotNull LDAPListenerClientConnection clientConnection, int messageID, @NotNull ModifyDNRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.modifyDNRequest = requestOp.toModifyDNRequest(requestControls);
        this.modifyDNResult = null;
    }

    @Override
    @NotNull
    public ReadOnlyModifyDNRequest getRequest() {
        return this.modifyDNRequest;
    }

    @Override
    public void setRequest(@NotNull ModifyDNRequest modifyDNRequest) {
        this.modifyDNRequest = modifyDNRequest;
    }

    @Override
    @Nullable
    public LDAPResult getResult() {
        return this.modifyDNResult;
    }

    @Override
    public void setResult(@NotNull LDAPResult modifyDNResult) {
        this.modifyDNResult = modifyDNResult;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedModifyDNOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.modifyDNRequest);
        buffer.append(", result=");
        buffer.append(this.modifyDNResult);
        buffer.append(')');
    }
}

