/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.processor.element.IElementProcessor;
import org.thymeleaf.util.ProcessorComparators;

public abstract class AttributeDefinition {
    final AttributeName attributeName;
    private final Set<IElementProcessor> associatedProcessorsSet;
    final IElementProcessor[] associatedProcessors;
    final boolean hasAssociatedProcessors;

    AttributeDefinition(AttributeName attributeName, Set<IElementProcessor> associatedProcessors) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (associatedProcessors == null) {
            throw new IllegalArgumentException("Associated processors cannot be null");
        }
        this.attributeName = attributeName;
        this.associatedProcessorsSet = Collections.unmodifiableSet(associatedProcessors);
        this.associatedProcessors = new IElementProcessor[this.associatedProcessorsSet.size()];
        int i = 0;
        for (IElementProcessor processor : this.associatedProcessorsSet) {
            this.associatedProcessors[i++] = processor;
        }
        Arrays.sort(this.associatedProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        this.hasAssociatedProcessors = this.associatedProcessors.length > 0;
    }

    public final AttributeName getAttributeName() {
        return this.attributeName;
    }

    public boolean hasAssociatedProcessors() {
        return this.hasAssociatedProcessors;
    }

    public Set<IElementProcessor> getAssociatedProcessors() {
        return this.associatedProcessorsSet;
    }

    public final String toString() {
        return this.getAttributeName().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        return this.attributeName.equals(that.attributeName);
    }

    public int hashCode() {
        return this.attributeName.hashCode();
    }
}

