/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.AttestationStatementVerifier;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.U2fRawRegisterResponse;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.X5cAttestationStatementVerifier;
import com.yubico.webauthn.data.AttestationObject;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AttestedCredentialData;
import com.yubico.webauthn.data.ByteArray;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FidoU2fAttestationStatementVerifier
implements AttestationStatementVerifier,
X5cAttestationStatementVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FidoU2fAttestationStatementVerifier.class);

    FidoU2fAttestationStatementVerifier() {
    }

    private X509Certificate getAttestationCertificate(AttestationObject attestationObject) throws CertificateException {
        return this.getX5cAttestationCertificate(attestationObject).map(attestationCertificate -> {
            if ("EC".equals(attestationCertificate.getPublicKey().getAlgorithm()) && Crypto.isP256(((ECPublicKey)attestationCertificate.getPublicKey()).getParams())) {
                return attestationCertificate;
            }
            throw new IllegalArgumentException("Attestation certificate for fido-u2f must have an ECDSA P-256 public key.");
        }).orElseThrow(() -> new IllegalArgumentException("fido-u2f attestation statement must have an \"x5c\" property set to an array of at least one DER encoded X.509 certificate."));
    }

    private static boolean validSelfSignature(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ByteArray getRawUserPublicKey(AttestationObject attestationObject) throws IOException, CoseException {
        ECPublicKey ecPubkey;
        PublicKey pubkey;
        ByteArray pubkeyCose = attestationObject.getAuthenticatorData().getAttestedCredentialData().get().getCredentialPublicKey();
        try {
            pubkey = WebAuthnCodecs.importCosePublicKey(pubkeyCose);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ExceptionUtil.wrapAndLog((Logger)log, (String)("Failed to decode public key: " + pubkeyCose.getHex()), (Throwable)e);
        }
        try {
            ecPubkey = (ECPublicKey)pubkey;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("U2F supports only EC keys, was: " + pubkey);
        }
        return WebAuthnCodecs.ecPublicKeyToRaw(ecPubkey);
    }

    @Override
    public AttestationType getAttestationType(AttestationObject attestationObject) throws CoseException, IOException, CertificateException {
        X509Certificate attestationCertificate = this.getAttestationCertificate(attestationObject);
        if (attestationCertificate.getPublicKey() instanceof ECPublicKey && FidoU2fAttestationStatementVerifier.validSelfSignature(attestationCertificate) && FidoU2fAttestationStatementVerifier.getRawUserPublicKey(attestationObject).equals(WebAuthnCodecs.ecPublicKeyToRaw((ECPublicKey)attestationCertificate.getPublicKey()))) {
            return AttestationType.SELF_ATTESTATION;
        }
        return AttestationType.BASIC;
    }

    @Override
    public boolean verifyAttestationSignature(AttestationObject attestationObject, ByteArray clientDataJsonHash) {
        X509Certificate attestationCertificate;
        try {
            attestationCertificate = this.getAttestationCertificate(attestationObject);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(String.format("Failed to parse X.509 certificate from attestation object: %s", attestationObject));
        }
        if (!"EC".equals(attestationCertificate.getPublicKey().getAlgorithm()) || !Crypto.isP256(((ECPublicKey)attestationCertificate.getPublicKey()).getParams())) {
            throw new IllegalArgumentException("Attestation certificate for fido-u2f must have an ECDSA P-256 public key.");
        }
        Optional<AttestedCredentialData> attData = attestationObject.getAuthenticatorData().getAttestedCredentialData();
        return attData.map(attestedCredentialData -> {
            JsonNode signature = attestationObject.getAttestationStatement().get("sig");
            if (signature == null) {
                throw new IllegalArgumentException("fido-u2f attestation statement must have a \"sig\" property set to a DER encoded signature.");
            }
            if (signature.isBinary()) {
                U2fRawRegisterResponse u2fRegisterResponse;
                ByteArray userPublicKey;
                try {
                    userPublicKey = FidoU2fAttestationStatementVerifier.getRawUserPublicKey(attestationObject);
                }
                catch (CoseException | IOException e) {
                    RuntimeException err = new RuntimeException(String.format("Failed to parse public key from attestation data %s", attestedCredentialData), e);
                    log.error(err.getMessage(), (Throwable)err);
                    throw err;
                }
                ByteArray keyHandle = attestedCredentialData.getCredentialId();
                try {
                    u2fRegisterResponse = new U2fRawRegisterResponse(userPublicKey, keyHandle, attestationCertificate, new ByteArray(signature.binaryValue()));
                }
                catch (IOException e) {
                    RuntimeException err = new RuntimeException("signature.isBinary() was true but signature.binaryValue() failed", e);
                    log.error(err.getMessage(), (Throwable)err);
                    throw err;
                }
                return u2fRegisterResponse.verifySignature(attestationObject.getAuthenticatorData().getRpIdHash(), clientDataJsonHash);
            }
            throw new IllegalArgumentException("\"sig\" property of fido-u2f attestation statement must be a CBOR byte array value.");
        }).orElseThrow(() -> new IllegalArgumentException("Attestation object for credential creation must have attestation data."));
    }
}

