/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springmodules.cache.serializable.XStreamSerializableFactory;
import org.w3c.dom.Element;

public abstract class AbstractCacheProviderFacadeParser
implements BeanDefinitionParser {
    public final BeanDefinition parse(Element element, ParserContext parserContext) throws IllegalStateException {
        String id = element.getAttribute("id");
        Class clazz = this.getCacheProviderFacadeClass();
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        RootBeanDefinition cacheProviderFacade = new RootBeanDefinition(clazz, propertyValues);
        propertyValues.addPropertyValue(this.parseFailQuietlyEnabledProperty(element));
        propertyValues.addPropertyValue(this.parseSerializableFactoryProperty(element));
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(id, (BeanDefinition)cacheProviderFacade);
        this.doParse(id, element, registry);
        return null;
    }

    protected void doParse(String cacheProviderFacadeId, Element element, BeanDefinitionRegistry registry) {
    }

    protected abstract Class getCacheProviderFacadeClass();

    private PropertyValue parseFailQuietlyEnabledProperty(Element element) {
        String failQuietlyAttr = element.getAttribute("failQuietly");
        Boolean value = "true".equalsIgnoreCase(failQuietlyAttr) ? Boolean.TRUE : Boolean.FALSE;
        return new PropertyValue("failQuietlyEnabled", (Object)value);
    }

    private PropertyValue parseSerializableFactoryProperty(Element element) throws IllegalStateException {
        String serializableFactoryAttr = element.getAttribute("serializableFactory");
        if (!StringUtils.hasText((String)serializableFactoryAttr) || "NONE".equalsIgnoreCase(serializableFactoryAttr)) {
            return new PropertyValue("serializableFactory", null);
        }
        if ("XSTREAM".equalsIgnoreCase(serializableFactoryAttr)) {
            return new PropertyValue("serializableFactory", (Object)new XStreamSerializableFactory());
        }
        throw new IllegalStateException(StringUtils.quote((String)serializableFactoryAttr) + " is not a serializableFactory. Valid values include " + StringUtils.quote((String)"NONE") + " and " + StringUtils.quote((String)"XSTREAM"));
    }

    private static abstract class SerializableFactory {
        static final String NONE = "NONE";
        static final String XSTREAM = "XSTREAM";

        private SerializableFactory() {
        }
    }

    private static abstract class PropertyName {
        static final String SERIALIZABLE_FACTORY = "serializableFactory";

        private PropertyName() {
        }
    }
}

