/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.lang.Nullable;

@Endpoint(id="ticketExpirationPolicies", enableByDefault=false)
public class TicketExpirationPoliciesEndpoint
extends BaseCasActuatorEndpoint {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final List<ExpirationPolicyBuilder> expirationPolicyBuilders;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    public TicketExpirationPoliciesEndpoint(CasConfigurationProperties casProperties, List<ExpirationPolicyBuilder> expirationPolicyBuilders, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        super(casProperties);
        this.expirationPolicyBuilders = expirationPolicyBuilders;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    private static String getTicketExpirationPolicyDetails(Serializable policy) throws Exception {
        return MAPPER.writeValueAsString((Object)policy);
    }

    @ReadOperation
    @Operation(summary="Produce expiration policies given an optional service id", parameters={@Parameter(name="serviceId")})
    public Map<String, String> handle(@Nullable String serviceId) throws Exception {
        HashMap<String, String> model = new HashMap<String, String>();
        this.expirationPolicyBuilders.forEach(Unchecked.consumer(builder -> {
            ExpirationPolicy policy = builder.buildTicketExpirationPolicy();
            String details = TicketExpirationPoliciesEndpoint.getTicketExpirationPolicyDetails((Serializable)policy);
            model.put(builder.getClass().getSimpleName(), details);
        }));
        RegisteredService registeredService = StringUtils.isNotBlank((CharSequence)serviceId) ? (NumberUtils.isCreatable((String)serviceId) ? this.servicesManager.findServiceBy(Long.parseLong(serviceId)) : this.servicesManager.findServiceBy(this.webApplicationServiceFactory.createService(serviceId))) : null;
        Optional.ofNullable(registeredService).map(CasModelRegisteredService.class::cast).map(RegisteredService::getTicketGrantingTicketExpirationPolicy).map(RegisteredServiceTicketGrantingTicketExpirationPolicy::toExpirationPolicy).filter(Optional::isPresent).map(Optional::get).ifPresent(Unchecked.consumer(policy -> {
            String details = TicketExpirationPoliciesEndpoint.getTicketExpirationPolicyDetails((Serializable)policy);
            model.put(TicketGrantingTicket.class.getName().concat(registeredService.getName()), details);
        }));
        Optional.ofNullable(registeredService).map(CasModelRegisteredService.class::cast).map(CasModelRegisteredService::getServiceTicketExpirationPolicy).ifPresent(Unchecked.consumer(policy -> {
            String details = TicketExpirationPoliciesEndpoint.getTicketExpirationPolicyDetails((Serializable)policy);
            model.put(ServiceTicket.class.getName().concat(registeredService.getName()), details);
        }));
        Optional.ofNullable(registeredService).map(CasModelRegisteredService.class::cast).map(CasModelRegisteredService::getProxyGrantingTicketExpirationPolicy).ifPresent(Unchecked.consumer(policy -> {
            String details = TicketExpirationPoliciesEndpoint.getTicketExpirationPolicyDetails((Serializable)policy);
            model.put(ProxyGrantingTicket.class.getName().concat(registeredService.getName()), details);
        }));
        Optional.ofNullable(registeredService).map(CasModelRegisteredService.class::cast).map(CasModelRegisteredService::getProxyTicketExpirationPolicy).ifPresent(Unchecked.consumer(policy -> {
            String details = TicketExpirationPoliciesEndpoint.getTicketExpirationPolicyDetails((Serializable)policy);
            model.put(ProxyTicket.class.getName().concat(registeredService.getName()), details);
        }));
        return model;
    }

    @Generated
    public List<ExpirationPolicyBuilder> getExpirationPolicyBuilders() {
        return this.expirationPolicyBuilders;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }
}

