/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.state.Enrollment;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.MessageID;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.IOException;

public class L2StateMessage
extends AbstractGroupMessage {
    public static final int START_ELECTION = 0;
    public static final int ELECTION_RESULT = 1;
    public static final int RESULT_AGREED = 2;
    public static final int RESULT_CONFLICT = 3;
    public static final int ABORT_ELECTION = 4;
    public static final int ELECTION_WON = 5;
    public static final int ELECTION_WON_ALREADY = 6;
    private Enrollment enrollment;
    private State state;

    public L2StateMessage() {
        super(-1);
    }

    public L2StateMessage(int type, Enrollment e, State state) {
        super(type);
        Assert.assertNotNull(e);
        this.enrollment = e;
        this.state = state;
    }

    public L2StateMessage(MessageID requestID, int type, Enrollment e, State state) {
        super(type, requestID);
        this.enrollment = e;
        this.state = state;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        this.enrollment = new Enrollment();
        this.enrollment.deserializeFrom(in);
        this.state = new State(in.readString());
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        this.enrollment.serializeTo(out);
        out.writeString(this.state.getName());
    }

    public Enrollment getEnrollment() {
        return this.enrollment;
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return "L2StateMessage [ " + this.messageFrom() + ", type = " + this.getTypeString() + ", " + this.enrollment + ", " + this.state + "]";
    }

    private String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return "START_ELECTION";
            }
            case 1: {
                return "ELECTION_RESULT";
            }
            case 2: {
                return "RESULT_AGREED";
            }
            case 3: {
                return "RESULT_CONFLICT";
            }
            case 4: {
                return "ABORT_ELECTION";
            }
            case 5: {
                return "ELECTION_WON";
            }
            case 6: {
                return "ELECTION_WON_ALREADY";
            }
        }
        throw new AssertionError((Object)("Unknow Type ! : " + this.getType()));
    }

    public static L2StateMessage createElectionStartedMessage(Enrollment e, State state) {
        return new L2StateMessage(0, e, state);
    }

    public static L2StateMessage createElectionResultMessage(Enrollment e, State state) {
        return new L2StateMessage(1, e, state);
    }

    public static L2StateMessage createAbortElectionMessage(L2StateMessage initiatingMsg, Enrollment e, State state) {
        return new L2StateMessage(initiatingMsg.getMessageID(), 4, e, state);
    }

    public static L2StateMessage createElectionStartedMessage(L2StateMessage initiatingMsg, Enrollment e, State state) {
        return new L2StateMessage(initiatingMsg.getMessageID(), 0, e, state);
    }

    public static L2StateMessage createResultConflictMessage(L2StateMessage initiatingMsg, Enrollment e, State state) {
        return new L2StateMessage(initiatingMsg.getMessageID(), 3, e, state);
    }

    public static L2StateMessage createResultAgreedMessage(L2StateMessage initiatingMsg, Enrollment e, State state) {
        return new L2StateMessage(initiatingMsg.getMessageID(), 2, e, state);
    }

    public static L2StateMessage createElectionWonMessage(Enrollment e, State state) {
        return new L2StateMessage(5, e, state);
    }

    public static L2StateMessage createElectionWonAlreadyMessage(Enrollment e, State state) {
        return new L2StateMessage(6, e, state);
    }
}

