/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.cipher;

import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceJwtTicketCipherExecutor
extends JwtTicketCipherExecutor
implements RegisteredServiceCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceJwtTicketCipherExecutor.class);

    public String decode(String data, Optional<RegisteredService> service) {
        RegisteredService registeredService;
        if (service.isPresent() && this.supports(registeredService = service.get())) {
            LOGGER.debug("Found signing and/or encryption keys for [{}] in service registry to decode", (Object)registeredService.getServiceId());
            JwtTicketCipherExecutor cipher = this.getTokenTicketCipherExecutorForService(registeredService);
            if (cipher.isEnabled()) {
                return cipher.decode((Serializable)((Object)data), new Object[]{registeredService});
            }
        }
        return this.decode((Serializable)((Object)data), ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY);
    }

    public String encode(String data, Optional<RegisteredService> service) {
        RegisteredService registeredService;
        if (service.isPresent() && this.supports(registeredService = service.get())) {
            LOGGER.debug("Found signing and/or encryption keys for [{}] in service registry to encode", (Object)registeredService.getServiceId());
            JwtTicketCipherExecutor cipher = this.getTokenTicketCipherExecutorForService(registeredService);
            if (cipher.isEnabled()) {
                return (String)cipher.encode(data);
            }
        }
        return this.encode((Serializable)((Object)data), ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY);
    }

    public boolean supports(RegisteredService registeredService) {
        return this.getSigningKey(registeredService).isPresent();
    }

    public JwtTicketCipherExecutor getTokenTicketCipherExecutorForService(RegisteredService registeredService) {
        String encryptionKey = this.getEncryptionKey(registeredService).orElse("");
        String signingKey = this.getSigningKey(registeredService).orElse("");
        BaseStringCipherExecutor.CipherOperationsStrategyType order = this.getCipherOperationsStrategyType(registeredService).orElse(BaseStringCipherExecutor.CipherOperationsStrategyType.ENCRYPT_AND_SIGN);
        return this.createCipherExecutorInstance(encryptionKey, signingKey, registeredService, order);
    }

    protected Optional<BaseStringCipherExecutor.CipherOperationsStrategyType> getCipherOperationsStrategyType(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getCipherStrategyTypeRegisteredServiceProperty(registeredService);
        if (property.isAssignedTo(registeredService)) {
            String order = property.getPropertyValue(registeredService).getValue();
            return Optional.of(BaseStringCipherExecutor.CipherOperationsStrategyType.valueOf((String)order));
        }
        return Optional.empty();
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService, BaseStringCipherExecutor.CipherOperationsStrategyType order) {
        JwtTicketCipherExecutor cipher = new JwtTicketCipherExecutor(encryptionKey, signingKey, StringUtils.isNotBlank((CharSequence)encryptionKey), StringUtils.isNotBlank((CharSequence)signingKey), 0, 0);
        cipher.setCustomHeaders(CollectionUtils.wrap((String)CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)registeredService.getId()));
        cipher.setStrategyType(order);
        return cipher;
    }

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getSigningKeyRegisteredServiceProperty();
        if (property.isAssignedTo(registeredService)) {
            String signingKey = property.getPropertyValue(registeredService).getValue();
            return Optional.of(signingKey);
        }
        return Optional.empty();
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getEncryptionKeyRegisteredServiceProperty();
        if (property.isAssignedTo(registeredService)) {
            String key = property.getPropertyValue(registeredService).getValue();
            return Optional.of(key);
        }
        return Optional.empty();
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherStrategyTypeRegisteredServiceProperty(RegisteredService registeredService) {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_CIPHER_STRATEGY_TYPE;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getSigningKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_SIGNING_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_ENCRYPTION_KEY;
    }

    @Generated
    public RegisteredServiceJwtTicketCipherExecutor() {
    }
}

