/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.button;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.form.button.AjaxButton;
import com.googlecode.wicket.jquery.ui.form.button.AjaxIndicatingButtonBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndicatingAjaxButton
extends AjaxButton {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IndicatingAjaxButton.class);
    private Position position = Position.LEFT;

    public IndicatingAjaxButton(String id) {
        super(id);
    }

    public IndicatingAjaxButton(String id, Form<?> form) {
        super(id, form);
    }

    public IndicatingAjaxButton(String id, IModel<String> model) {
        super(id, model);
    }

    public IndicatingAjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model, form);
    }

    public IndicatingAjaxButton setPosition(Position position) {
        this.position = position;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("IndicatingAjaxButton should be applied on a 'button' tag");
        }
    }

    protected boolean isDisabledOnClick() {
        return false;
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AjaxIndicatingButtonBehavior(selector, this.getIcon(), this.position){
            private static final long serialVersionUID = 1L;

            @Override
            protected Options newAjaxStartOptions() {
                Options options = super.newAjaxStartOptions();
                if (IndicatingAjaxButton.this.isDisabledOnClick()) {
                    options.set("disabled", (Object)true);
                }
                return options;
            }

            @Override
            protected Options newOnAjaxStopOptions() {
                Options options = super.newOnAjaxStopOptions();
                if (IndicatingAjaxButton.this.isDisabledOnClick()) {
                    options.set("disabled", (Object)(!IndicatingAjaxButton.this.isEnabledInHierarchy() ? 1 : 0));
                }
                return options;
            }
        };
    }

    public static enum Position {
        LEFT,
        RIGHT;

    }
}

