/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications;

import java.util.List;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.notifications.call.PhoneCallRequest;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsRequest;

public interface CommunicationsManager {
    public static final String BEAN_NAME = "communicationsManager";

    public boolean isMailSenderDefined();

    public boolean isSmsSenderDefined();

    public boolean isNotificationSenderDefined();

    public boolean isPhoneOperatorDefined();

    public boolean notify(Principal var1, String var2, String var3);

    public EmailCommunicationResult email(EmailMessageRequest var1);

    public boolean sms(SmsRequest var1);

    default public boolean sms(List<SmsRequest> requests) throws Throwable {
        return requests.stream().anyMatch(this::sms);
    }

    public boolean phoneCall(PhoneCallRequest var1) throws Throwable;

    public boolean validate();

    default public boolean isCommunicationChannelAvailable() {
        return this.isMailSenderDefined() || this.isSmsSenderDefined() || this.isPhoneOperatorDefined() || this.isNotificationSenderDefined();
    }
}

