/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.credential;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetadata;
import org.apereo.cas.authentication.metadata.BasicCredentialMetadata;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class AbstractCredential
implements Credential {
    private static final long serialVersionUID = 8196868021183513898L;
    private CredentialMetadata credentialMetadata;

    public CredentialMetadata getCredentialMetadata() {
        if (this.credentialMetadata == null) {
            this.credentialMetadata = new BasicCredentialMetadata(this);
        }
        return this.credentialMetadata;
    }

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.getId());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Credential) {
            Credential credential = (Credential)other;
            return Objects.equals(this.getId(), credential.getId());
        }
        return false;
    }

    public void validate(ValidationContext context) {
        if (!this.isValid()) {
            MessageContext messages = context.getMessageContext();
            messages.addMessage(new MessageBuilder().error().source((Object)"token").defaultText("Unable to accept credential with an empty or unspecified token").build());
        }
    }

    @Generated
    public String toString() {
        return "AbstractCredential(credentialMetadata=" + String.valueOf(this.credentialMetadata) + ")";
    }

    @Generated
    public void setCredentialMetadata(CredentialMetadata credentialMetadata) {
        this.credentialMetadata = credentialMetadata;
    }
}

