/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.observation;

public final class SecurityObservationSettings {
    private final boolean observeRequests;
    private final boolean observeAuthentications;
    private final boolean observeAuthorizations;

    private SecurityObservationSettings(boolean observeRequests, boolean observeAuthentications, boolean observeAuthorizations) {
        this.observeRequests = observeRequests;
        this.observeAuthentications = observeAuthentications;
        this.observeAuthorizations = observeAuthorizations;
    }

    public static SecurityObservationSettings noObservations() {
        return new SecurityObservationSettings(false, false, false);
    }

    public static Builder withDefaults() {
        return new Builder(false, true, true);
    }

    public boolean shouldObserveRequests() {
        return this.observeRequests;
    }

    public boolean shouldObserveAuthentications() {
        return this.observeAuthentications;
    }

    public boolean shouldObserveAuthorizations() {
        return this.observeAuthorizations;
    }

    public static final class Builder {
        private boolean observeRequests;
        private boolean observeAuthentications;
        private boolean observeAuthorizations;

        Builder(boolean observeRequests, boolean observeAuthentications, boolean observeAuthorizations) {
            this.observeRequests = observeRequests;
            this.observeAuthentications = observeAuthentications;
            this.observeAuthorizations = observeAuthorizations;
        }

        public Builder shouldObserveRequests(boolean excludeFilters) {
            this.observeRequests = excludeFilters;
            return this;
        }

        public Builder shouldObserveAuthentications(boolean excludeAuthentications) {
            this.observeAuthentications = excludeAuthentications;
            return this;
        }

        public Builder shouldObserveAuthorizations(boolean excludeAuthorizations) {
            this.observeAuthorizations = excludeAuthorizations;
            return this;
        }

        public SecurityObservationSettings build() {
            return new SecurityObservationSettings(this.observeRequests, this.observeAuthentications, this.observeAuthorizations);
        }
    }
}

