/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.CasProtocolVersions;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;

public class CasProtocolVersionValidationSpecification
implements CasProtocolValidationSpecification {
    private final Set<CasProtocolVersions> supportedVersions;
    private final TenantExtractor tenantExtractor;

    public boolean isSatisfiedBy(Assertion assertion, HttpServletRequest request) {
        Boolean tenantSupported = this.tenantExtractor.extract(request).stream().filter(tenant -> Objects.nonNull(tenant.getAuthenticationPolicy().getAuthenticationProtocolPolicy())).map(tenant -> {
            Set supportedProtocols = tenant.getAuthenticationPolicy().getAuthenticationProtocolPolicy().getSupportedProtocols().stream().map(version -> CasProtocolVersions.valueOf((String)version.toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
            return supportedProtocols.isEmpty() || supportedProtocols.containsAll(this.supportedVersions);
        }).findAny().orElse(Boolean.TRUE);
        RegisteredService registeredService = assertion.getRegisteredService();
        if (tenantSupported.booleanValue() && registeredService instanceof CasModelRegisteredService) {
            CasModelRegisteredService casService = (CasModelRegisteredService)registeredService;
            Set supportedProtocols = casService.getSupportedProtocols();
            return supportedProtocols.isEmpty() || supportedProtocols.containsAll(this.supportedVersions);
        }
        return tenantSupported;
    }

    @Generated
    public CasProtocolVersionValidationSpecification(Set<CasProtocolVersions> supportedVersions, TenantExtractor tenantExtractor) {
        this.supportedVersions = supportedVersions;
        this.tenantExtractor = tenantExtractor;
    }
}

