/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.brands;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.brands.EmailTemplate;
import com.okta.sdk.resource.brands.EmailTemplateContent;
import com.okta.sdk.resource.brands.EmailTemplateCustomization;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationList;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationRequest;
import com.okta.sdk.resource.brands.EmailTemplateTestRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEmailTemplate
extends AbstractInstanceResource<EmailTemplate>
implements EmailTemplate {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultEmailTemplate.createPropertyDescriptorMap(linksProperty, nameProperty);

    public DefaultEmailTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultEmailTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return EmailTemplate.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public void deleteEmailTemplateCustomization(String brandId, String templateName, String customizationId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        Assert.hasText((String)customizationId, (String)"'customizationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void sendTestEmail(String brandId, String templateName, EmailTemplateTestRequest customization) {
        Assert.notNull((Object)customization, (String)"'customization' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/test", customization, this, VoidResource.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateCustomization getEmailTemplateCustomization(String brandId, String templateName, String customizationId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        Assert.hasText((String)customizationId, (String)"'customizationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "", EmailTemplateCustomization.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateContent getEmailTemplateCustomizationPreview(String brandId, String templateName, String customizationId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        Assert.hasText((String)customizationId, (String)"'customizationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "/preview", EmailTemplateContent.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateCustomization createEmailTemplateCustomization(String brandId, String templateName, EmailTemplateCustomizationRequest customization) {
        Assert.notNull((Object)customization, (String)"'customization' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations", customization, this, EmailTemplateCustomization.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateContent getEmailTemplateDefaultContentPreview(String brandId, String templateName) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/default-content/preview", EmailTemplateContent.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteEmailTemplateCustomizations(String brandId, String templateName) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations", queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateCustomizationList listEmailTemplateCustomizations(String brandId, String templateName) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations", EmailTemplateCustomizationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplateCustomization updateEmailTemplateCustomization(String brandId, String templateName, String customizationId, EmailTemplateCustomizationRequest customization) {
        Assert.notNull((Object)customization, (String)"'customization' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        Assert.hasText((String)customizationId, (String)"'customizationId' is required and cannot be null or empty.");
        HashMap queryArgs = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "";
        return this.getDataStore().save(href, customization, EmailTemplateCustomization.class, false);
    }

    public EmailTemplateContent getEmailTemplateDefaultContent(String brandId, String templateName) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/default-content", EmailTemplateContent.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EmailTemplate getEmailTemplate(String brandId, String templateName) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)templateName, (String)"'templateName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/templates/email/" + templateName + "", EmailTemplate.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

