/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apereo.cas.configuration.CasCoreConfigurationUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class WAConfUtils {
    private static final YAMLMapper YAML_MAPPER = new YAMLMapper();

    public static Map<String, Object> asMap(Serializable properties) {
        return (Map)FunctionUtils.doUnchecked(() -> {
            try (StringWriter writer = new StringWriter();){
                YAML_MAPPER.writeValue((Writer)writer, (Object)properties);
                ByteArrayResource resource = new ByteArrayResource(writer.toString().getBytes(StandardCharsets.UTF_8));
                Map map = CasCoreConfigurationUtils.loadYamlProperties((Resource[])new Resource[]{resource});
                return map;
            }
        });
    }

    private WAConfUtils() {
    }

    static {
        YAML_MAPPER.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        YAML_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        YAML_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Resource.class, (JsonSerializer)new ResourceSerializer());
        YAML_MAPPER.registerModule((Module)module);
    }

    private static class ResourceSerializer
    extends StdSerializer<Resource> {
        private static final long serialVersionUID = 7971411664567411958L;

        ResourceSerializer() {
            this(null);
        }

        ResourceSerializer(Class<Resource> t) {
            super(t);
        }

        public void serialize(Resource value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value instanceof ClassPathResource) {
                jgen.writeString("classpath:" + value.getFilename());
            } else {
                jgen.writeString(value.getURI().toString());
            }
        }
    }
}

