/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.security.auth.login.AccountLockedException;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AccountUnlockStatusAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountUnlockStatusAction.class);
    private final PasswordManagementService passwordManagementService;

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            Credential credential = (Credential)requestContext.getConversationScope().get(Credential.class.getName(), Credential.class);
            LOGGER.debug("Attempting to unlock account for [{}]", (Object)credential);
            String givenValue = (String)requestContext.getConversationScope().get("captchaValue", String.class);
            String providedValue = (String)WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)"captchaValue").orElseThrow();
            LOGGER.debug("Comparing captcha value [{}] with user entry [{}]", (Object)givenValue, (Object)providedValue);
            if (!givenValue.equals(providedValue) || !this.passwordManagementService.unlockAccount(credential)) {
                throw new AccountLockedException("Captcha value does not match, or CAS cannot unlock the account for " + credential.getId());
            }
            WebUtils.addInfoMessageToContext((RequestContext)requestContext, (String)"screen.account.unlock.success");
            return this.success();
        }
        catch (Throwable e) {
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"screen.account.unlock.fail");
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.error();
        }
    }

    @Generated
    public AccountUnlockStatusAction(PasswordManagementService passwordManagementService) {
        this.passwordManagementService = passwordManagementService;
    }
}

