/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorPrepareLoginAction
extends AbstractMultifactorAuthenticationAction {
    protected final CasConfigurationProperties casProperties;
    protected final OneTimeTokenCredentialRepository repository;
    protected final TenantExtractor tenantExtractor;

    protected Event doExecuteInternal(RequestContext requestContext) {
        Principal principal = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal(), requestContext);
        boolean enabled = this.isMultipleDeviceRegistrationEnabled(requestContext) && this.repository.count(principal.getId()) >= 1L && MultifactorAuthenticationWebflowUtils.isMultifactorDeviceRegistrationEnabled((RequestContext)requestContext);
        MultifactorAuthenticationWebflowUtils.putGoogleAuthenticatorMultipleDeviceRegistrationEnabled((RequestContext)requestContext, (boolean)enabled);
        MultifactorAuthenticationWebflowUtils.putOneTimeTokenAccounts((RequestContext)requestContext, (Collection)this.repository.get(principal.getId()));
        return null;
    }

    private boolean isMultipleDeviceRegistrationEnabled(RequestContext requestContext) {
        return this.tenantExtractor.extract(requestContext).filter(tenantDefinition -> !tenantDefinition.getProperties().isEmpty()).map(TenantDefinition::bindProperties).filter(ConfigurationPropertiesBindingContext::isBound).filter(bindingContext -> bindingContext.containsBindingFor(CoreGoogleAuthenticatorMultifactorProperties.class)).map(ConfigurationPropertiesBindingContext::value).map(properties -> properties.getAuthn().getMfa().getGauth().getCore().isMultipleDeviceRegistrationEnabled()).orElseGet(() -> this.casProperties.getAuthn().getMfa().getGauth().getCore().isMultipleDeviceRegistrationEnabled());
    }

    @Generated
    public GoogleAuthenticatorPrepareLoginAction(CasConfigurationProperties casProperties, OneTimeTokenCredentialRepository repository, TenantExtractor tenantExtractor) {
        this.casProperties = casProperties;
        this.repository = repository;
        this.tenantExtractor = tenantExtractor;
    }
}

