/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FinishLogoutAction
extends AbstractLogoutAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishLogoutAction.class);

    public FinishLogoutAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        super(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
    }

    @Override
    protected Event doInternalExecute(RequestContext context) {
        String logoutRedirect = (String)WebUtils.getLogoutRedirectUrl((RequestContext)context, String.class);
        if (StringUtils.isNotBlank((CharSequence)logoutRedirect)) {
            LOGGER.debug("Redirecting to [{}]", (Object)logoutRedirect);
            return this.eventFactory.event((Object)this, "redirect");
        }
        String logoutPostUrl = WebUtils.getLogoutPostUrl((RequestContext)context);
        Map logoutPostData = WebUtils.getLogoutPostData((RequestContext)context);
        if (StringUtils.isNotBlank((CharSequence)logoutPostUrl) && logoutPostData != null) {
            MutableAttributeMap flowScope = context.getFlowScope();
            flowScope.put("originalUrl", (Object)logoutPostUrl);
            flowScope.put("parameters", (Object)logoutPostData);
            LOGGER.debug("Submitting POST logout request to [{}] with parameters [{}]", (Object)logoutPostUrl, (Object)logoutPostData);
            return this.eventFactory.event((Object)this, "post");
        }
        return this.eventFactory.event((Object)this, "finish");
    }
}

