/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.fault;

import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.FaultHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFaultHandler
implements FaultHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingFaultHandler.class);
    private final String type;
    private final Runnable action;

    public LoggingFaultHandler(String type, Runnable action) {
        this.type = type;
        this.action = action;
    }

    @Override
    public RuntimeException handleFault(String failureMessage, Throwable cause) {
        if (cause == null) {
            log.error("Encountered {} fault: {}", (Object)this.type, (Object)failureMessage);
        } else {
            log.error("Encountered {} fault: {}", new Object[]{this.type, failureMessage, cause});
        }
        try {
            this.action.run();
        }
        catch (Throwable e) {
            log.error("Failed to run LoggingFaultHandler action.", e);
        }
        return new FaultHandlerException(failureMessage, cause);
    }
}

