/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.runtime;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;

public class EventInstanceImpl
implements EventInstance {
    protected String eventKey;
    protected Collection<EventPayloadInstance> payloadInstances;
    protected Collection<EventPayloadInstance> headerInstances;
    protected Collection<EventPayloadInstance> correlationPayloadInstances;
    protected String tenantId;

    public EventInstanceImpl(String eventKey, Collection<EventPayloadInstance> payloadInstances) {
        this(eventKey, payloadInstances, "");
    }

    public EventInstanceImpl(String eventKey, Collection<EventPayloadInstance> payloadInstances, String tenantId) {
        this.eventKey = eventKey;
        this.payloadInstances = payloadInstances;
        this.headerInstances = this.payloadInstances.stream().filter(eventPayloadInstance -> eventPayloadInstance.getEventPayloadDefinition().isHeader()).collect(Collectors.toList());
        this.correlationPayloadInstances = this.payloadInstances.stream().filter(eventPayloadInstance -> eventPayloadInstance.getEventPayloadDefinition().isCorrelationParameter()).collect(Collectors.toList());
        this.tenantId = tenantId;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public Collection<EventPayloadInstance> getPayloadInstances() {
        return this.payloadInstances;
    }

    public void setPayloadInstances(Collection<EventPayloadInstance> payloadInstances) {
        this.payloadInstances = payloadInstances;
    }

    public Collection<EventPayloadInstance> getHeaderInstances() {
        return this.headerInstances;
    }

    public void setHeaderInstances(Collection<EventPayloadInstance> headerInstances) {
        this.headerInstances = headerInstances;
    }

    public Collection<EventPayloadInstance> getCorrelationParameterInstances() {
        return this.correlationPayloadInstances;
    }

    public void setCorrelationParameterInstances(Collection<EventPayloadInstance> correlationParameterInstances) {
        this.correlationPayloadInstances = correlationParameterInstances;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EventInstance[eventKey=").append(this.eventKey);
        if (StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            sb.append(", tenantId=").append(this.tenantId);
        }
        sb.append("]");
        return sb.toString();
    }
}

