/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SecurityContextUtils;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.apereo.cas.webauthn.web.BaseWebAuthnController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="WebAuthN")
@RequestMapping(value={"/webauthn"})
public class WebAuthnQRCodeController
extends BaseWebAuthnController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnQRCodeController.class);
    public static final String ENDPOINT_QR_VERIFY = "/qrverify";
    protected final CasConfigurationProperties casProperties;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;
    protected final RegistrationStorage webAuthnCredentialRepository;
    protected final SessionManager sessionManager;
    protected final SecurityContextRepository securityContextRepository;

    @GetMapping(value={"/qrverify/{ticketId}"})
    @Operation(summary="Start WebAuthn QR code authentication", parameters={@Parameter(name="ticketId", in=ParameterIn.PATH, required=true, description="Ticket id")})
    public ModelAndView startAuthentication(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="ticketId") String ticketId) throws Throwable {
        try {
            this.verifyQRCodeAuthenticationIsEnabled();
            TransientSessionTicket transientTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            Assert.isTrue((transientTicket != null && !transientTicket.isExpired() ? 1 : 0) != 0, (String)"Ticket not found or has expired");
            SecurityContext context = SecurityContextUtils.createSecurityContext((TransientSessionTicket)transientTicket, (HttpServletRequest)request);
            this.securityContextRepository.saveContext(context, request, response);
            Principal principal = (Principal)transientTicket.getProperty(Principal.class.getName(), Principal.class);
            return new ModelAndView("webauthn/casWebAuthnQRCodeVerifyView", Map.of("QRCodeTicket", transientTicket, "principal", principal, "QRCodeAuthentication", true));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ModelAndView("webauthn/casWebAuthnQRCodeVerifyDoneView", Map.of("success", false));
        }
    }

    @Operation(summary="Check QR ticket status", parameters={@Parameter(name="ticketId", in=ParameterIn.PATH, required=true, description="Ticket id")})
    @GetMapping(value={"/qrverify/{ticketId}/status"})
    @ResponseBody
    public ResponseEntity checkQRTicketStatus(HttpServletRequest request, @PathVariable(value="ticketId") String ticketId) throws Throwable {
        try {
            this.verifyQRCodeAuthenticationIsEnabled();
            TransientSessionTicket transientTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            Assert.isTrue((transientTicket != null && !transientTicket.isExpired() ? 1 : 0) != 0, (String)"Ticket not found or has expired");
            WebAuthnCredential webAuthnCredential = (WebAuthnCredential)((Object)transientTicket.getProperty(WebAuthnCredential.class.getName(), WebAuthnCredential.class));
            if (webAuthnCredential == null) {
                return ResponseEntity.unprocessableEntity().body(Map.of("ticketId", ticketId, "message", "WebAuthn credential not found in the ticket"));
            }
            Assert.notNull((Object)((Object)webAuthnCredential), (String)"WebAuthn credential not found in the ticket");
            Principal principal = (Principal)transientTicket.getProperty(Principal.class.getName(), Principal.class);
            Optional<ByteArray> session = this.sessionManager.getSession(request, WebAuthnCredential.from(webAuthnCredential));
            Assert.isTrue((boolean)session.isPresent(), (String)"Session is not found for the given credential");
            this.ticketRegistry.deleteTicket(ticketId);
            return ResponseEntity.ok(Map.of("principal", principal, "sessionToken", webAuthnCredential.getToken()));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.badRequest().body(Map.of("ticketId", ticketId, "message", e.getMessage()));
        }
    }

    @PostMapping(value={"/qrverify"})
    @ResponseBody
    @Operation(summary="Verify QR code token", parameters={@Parameter(name="token", required=true, in=ParameterIn.QUERY, description="Session token"), @Parameter(name="ticket", required=true, in=ParameterIn.QUERY, description="Ticket id"), @Parameter(name="principal", required=true, in=ParameterIn.QUERY, description="Principal id")})
    public ModelAndView verifyCode(HttpServletRequest request, @RequestParam(value="token") String sessionToken, @RequestParam(value="ticket") String ticketId, @RequestParam(value="principal") String principalId) throws Throwable {
        try {
            this.verifyQRCodeAuthenticationIsEnabled();
            TransientSessionTicket transientTicket = (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            Assert.isTrue((transientTicket != null && !transientTicket.isExpired() ? 1 : 0) != 0, (String)"Ticket is not found or has expired");
            Assert.isTrue((boolean)this.webAuthnCredentialRepository.userExists(principalId), (String)"Principal not found");
            Principal principal = (Principal)transientTicket.getProperty(Principal.class.getName(), Principal.class);
            WebAuthnCredential credential = new WebAuthnCredential(sessionToken);
            Optional<ByteArray> session = this.sessionManager.getSession(request, WebAuthnCredential.from(credential));
            FunctionUtils.throwIf((boolean)session.isEmpty(), () -> new IllegalStateException("Session not found for the given credential"));
            Optional result = this.webAuthnCredentialRepository.getUsernameForUserHandle(session.get());
            FunctionUtils.throwIf((boolean)result.isEmpty(), () -> new IllegalStateException("Unable to locate user based on the given user handle"));
            transientTicket.putProperty(WebAuthnCredential.class.getName(), (Serializable)((Object)credential));
            this.ticketRegistry.updateTicket((Ticket)transientTicket);
            return new ModelAndView("webauthn/casWebAuthnQRCodeVerifyDoneView", Map.of("principal", principal, "success", true));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            this.ticketRegistry.deleteTicket(ticketId);
            return new ModelAndView("webauthn/casWebAuthnQRCodeVerifyDoneView", Map.of("success", false));
        }
    }

    private boolean isQRCodeAuthenticationEnabled() {
        return this.casProperties.getAuthn().getMfa().getWebAuthn().getCore().isQrCodeAuthenticationEnabled();
    }

    protected void verifyQRCodeAuthenticationIsEnabled() throws Throwable {
        FunctionUtils.throwIf((!this.isQRCodeAuthenticationEnabled() ? 1 : 0) != 0, () -> new NotImplementedException("QR code authentication is not enabled"));
    }

    @Generated
    public WebAuthnQRCodeController(CasConfigurationProperties casProperties, TicketRegistry ticketRegistry, TicketFactory ticketFactory, RegistrationStorage webAuthnCredentialRepository, SessionManager sessionManager, SecurityContextRepository securityContextRepository) {
        this.casProperties = casProperties;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
        this.sessionManager = sessionManager;
        this.securityContextRepository = securityContextRepository;
    }
}

