/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.common.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAttributable;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractAnyRepoExt<A extends Any>
implements AnyRepoExt<A> {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyRepoExt.class);
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final EntityManager entityManager;
    protected final AnyFinder anyFinder;
    protected final AnyUtils anyUtils;
    protected final String table;

    protected AbstractAnyRepoExt(PlainSchemaDAO plainSchemaDAO, EntityManager entityManager, AnyFinder anyFinder, AnyUtils anyUtils) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.entityManager = entityManager;
        this.anyFinder = anyFinder;
        this.anyUtils = anyUtils;
        switch (anyUtils.anyTypeKind()) {
            case ANY_OBJECT: {
                this.table = "AnyObject";
                break;
            }
            case GROUP: {
                this.table = "SyncopeGroup";
                break;
            }
            default: {
                this.table = "SyncopeUser";
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<OffsetDateTime> findLastChange(String key) {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)this.entityManager.getEntityManagerFactory().unwrap(OpenJPAEntityManagerFactorySPI.class);
        return (Optional)new JdbcTemplate((DataSource)emf.getConfiguration().getConnectionFactory()).query("SELECT creationDate, lastChangeDate FROM " + this.table + " WHERE id=?", rs -> {
            if (rs.next()) {
                OffsetDateTime creationDate = rs.getObject(1, OffsetDateTime.class);
                OffsetDateTime lastChangeDate = rs.getObject(2, OffsetDateTime.class);
                return Optional.ofNullable(lastChangeDate).or(() -> Optional.ofNullable(creationDate));
            }
            return Optional.empty();
        }, new Object[]{key});
    }

    protected abstract void securityChecks(A var1);

    protected Optional<A> findById(String key) {
        return Optional.ofNullable((Any)this.entityManager.find(this.anyUtils.anyClass(), (Object)key));
    }

    @Override
    @Transactional(readOnly=true)
    public A authFind(String key) {
        if (key == null) {
            throw new NotFoundException("Null key");
        }
        Any any = (Any)this.findById(key).orElseThrow(() -> new NotFoundException(this.anyUtils.anyTypeKind().name() + " " + key));
        this.securityChecks(any);
        return (A)any;
    }

    @Override
    public List<A> findByDerAttrValue(String expression, String value, boolean ignoreCaseMatch) {
        return this.anyFinder.findByDerAttrValue(this.anyUtils.anyTypeKind(), expression, value, ignoreCaseMatch);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public <S extends Schema> AllowedSchemas<S> findAllowedSchemas(A any, Class<S> reference) {
        AllowedSchemas result = new AllowedSchemas();
        HashSet typeOwnClasses = new HashSet();
        typeOwnClasses.addAll(any.getType().getClasses());
        typeOwnClasses.addAll(any.getAuxClasses());
        typeOwnClasses.forEach(typeClass -> {
            if (reference.equals(PlainSchema.class)) {
                result.self().addAll(typeClass.getPlainSchemas());
            } else if (reference.equals(DerSchema.class)) {
                result.self().addAll(typeClass.getDerSchemas());
            }
        });
        HashMap gTypeExtensionClasses = new HashMap();
        Object a = any;
        Objects.requireNonNull(a);
        Object a2 = a;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{User.class, AnyObject.class}, a2, n)) {
            case 0: {
                User user = (User)a2;
                user.getMemberships().forEach(memb -> ((Group)memb.getRightEnd()).getTypeExtensions().forEach(typeExt -> gTypeExtensionClasses.put((Group)memb.getRightEnd(), typeExt.getAuxClasses())));
                break;
            }
            case 1: {
                AnyObject anyObject = (AnyObject)a2;
                anyObject.getMemberships().forEach(memb -> ((Group)memb.getRightEnd()).getTypeExtensions().stream().filter(typeExt -> any.getType().equals((Object)typeExt.getAnyType())).forEach(typeExt -> gTypeExtensionClasses.put((Group)memb.getRightEnd(), typeExt.getAuxClasses())));
                break;
            }
        }
        gTypeExtensionClasses.entrySet().stream().peek(entry -> result.memberships().put((Group)entry.getKey(), new HashSet())).forEach(entry -> ((List)entry.getValue()).forEach(typeClass -> {
            if (reference.equals(PlainSchema.class)) {
                ((Set)result.memberships().get(entry.getKey())).addAll(typeClass.getPlainSchemas());
            } else if (reference.equals(DerSchema.class)) {
                ((Set)result.memberships().get(entry.getKey())).addAll(typeClass.getDerSchemas());
            }
        }));
        HashMap rTypeExtensionClasses = new HashMap();
        Object a3 = any;
        Objects.requireNonNull(a3);
        Object a4 = a3;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{User.class, AnyObject.class}, a4, n2)) {
            case 0: {
                User user = (User)a4;
                user.getRelationships().stream().map(Relationship::getType).distinct().forEach(rt -> rt.getTypeExtensions().forEach(typeExt -> rTypeExtensionClasses.put(rt, typeExt.getAuxClasses())));
                break;
            }
            case 1: {
                AnyObject anyObject = (AnyObject)a4;
                anyObject.getRelationships().stream().map(Relationship::getType).distinct().forEach(rt -> rt.getTypeExtensions().forEach(typeExt -> rTypeExtensionClasses.put(rt, typeExt.getAuxClasses())));
                break;
            }
        }
        rTypeExtensionClasses.entrySet().stream().peek(entry -> result.relationshipTypes().put((RelationshipType)entry.getKey(), new HashSet())).forEach(entry -> ((List)entry.getValue()).forEach(typeClass -> {
            if (reference.equals(PlainSchema.class)) {
                ((Set)result.relationshipTypes().get(entry.getKey())).addAll(typeClass.getPlainSchemas());
            } else if (reference.equals(DerSchema.class)) {
                ((Set)result.relationshipTypes().get(entry.getKey())).addAll(typeClass.getDerSchemas());
            }
        }));
        return result;
    }

    @Override
    public void deleteRelationship(Relationship<? extends A, AnyObject> relationship) {
        this.entityManager.remove(relationship);
    }

    protected <T extends AbstractAttributable> void checkBeforeSave(T attributable) {
        new ArrayList<PlainAttr>(attributable.getPlainAttrsList()).stream().filter(attr -> attr.getUniqueValue() != null).forEach(attr -> {
            if (this.plainSchemaDAO.existsPlainAttrUniqueValue(this.anyUtils, attributable.getKey(), (PlainSchema)this.plainSchemaDAO.findById(attr.getSchema()).orElseThrow(() -> new NotFoundException("PlainSchema " + attr.getSchema())), attr.getUniqueValue())) {
                throw new DuplicateException("Duplicate value found for " + attr.getSchema() + "=" + attr.getUniqueValue().getValueAsString());
            }
            LOG.debug("No duplicate value found for {}={}", (Object)attr.getSchema(), (Object)attr.getUniqueValue().getValueAsString());
        });
        if (attributable instanceof Any) {
            Any any = (Any)attributable;
            OffsetDateTime now = OffsetDateTime.now();
            String who = AuthContextUtils.getWho();
            LOG.debug("Set last change date '{}' and modifier '{}' for '{}'", new Object[]{now, who, any});
            any.setLastModifier(who);
            any.setLastChangeDate(now);
        }
    }

    @Override
    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }
}

