/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.EntityPersister;

public class Subclass
extends PersistentClass {
    private PersistentClass superclass;
    private Class<? extends EntityPersister> classPersisterClass;
    private final int subclassId;

    public Subclass(PersistentClass superclass, MetadataBuildingContext buildingContext) {
        super(buildingContext);
        this.superclass = superclass;
        this.subclassId = superclass.nextSubclassId();
    }

    @Override
    int nextSubclassId() {
        return this.getSuperclass().nextSubclassId();
    }

    @Override
    public int getSubclassId() {
        return this.subclassId;
    }

    @Override
    public String getNaturalIdCacheRegionName() {
        return this.getSuperclass().getNaturalIdCacheRegionName();
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.getRootClass().getCacheConcurrencyStrategy();
    }

    @Override
    public RootClass getRootClass() {
        return this.getSuperclass().getRootClass();
    }

    @Override
    public PersistentClass getSuperclass() {
        return this.superclass;
    }

    @Override
    public Property getIdentifierProperty() {
        return this.getSuperclass().getIdentifierProperty();
    }

    @Override
    public Property getDeclaredIdentifierProperty() {
        return null;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.getSuperclass().getIdentifier();
    }

    @Override
    public boolean hasIdentifierProperty() {
        return this.getSuperclass().hasIdentifierProperty();
    }

    @Override
    public Value getDiscriminator() {
        return this.getSuperclass().getDiscriminator();
    }

    @Override
    public boolean isMutable() {
        return this.getSuperclass().isMutable();
    }

    @Override
    public boolean isInherited() {
        return true;
    }

    @Override
    public boolean isPolymorphic() {
        return true;
    }

    @Override
    public void addProperty(Property property) {
        super.addProperty(property);
        this.getSuperclass().addSubclassProperty(property);
    }

    @Override
    @Internal
    public void movePropertyToJoin(Property property, Join join) {
        super.movePropertyToJoin(property, join);
        this.getSuperclass().moveSubclassPropertyToJoin(property);
    }

    @Override
    @Internal
    protected void moveSubclassPropertyToJoin(Property property) {
        super.moveSubclassPropertyToJoin(property);
        this.getSuperclass().moveSubclassPropertyToJoin(property);
    }

    @Override
    public void addMappedSuperclassProperty(Property property) {
        super.addMappedSuperclassProperty(property);
        this.getSuperclass().addSubclassProperty(property);
    }

    @Override
    public void addJoin(Join j) {
        super.addJoin(j);
        this.getSuperclass().addSubclassJoin(j);
    }

    @Override
    public List<Property> getPropertyClosure() {
        return new JoinedList<Property>(this.getSuperclass().getPropertyClosure(), this.getProperties());
    }

    @Override
    public List<Table> getTableClosure() {
        return new JoinedList<Table>(this.getSuperclass().getTableClosure(), List.of(this.getTable()));
    }

    @Override
    public List<KeyValue> getKeyClosure() {
        return new JoinedList<KeyValue>(this.getSuperclass().getKeyClosure(), List.of(this.getKey()));
    }

    @Override
    protected void addSubclassProperty(Property p) {
        super.addSubclassProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    @Override
    protected void addSubclassJoin(Join j) {
        super.addSubclassJoin(j);
        this.getSuperclass().addSubclassJoin(j);
    }

    @Override
    protected void addSubclassTable(Table table) {
        super.addSubclassTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    @Override
    public boolean isVersioned() {
        return this.getSuperclass().isVersioned();
    }

    @Override
    public Property getVersion() {
        return this.getSuperclass().getVersion();
    }

    @Override
    public Property getDeclaredVersion() {
        return null;
    }

    @Override
    public boolean hasEmbeddedIdentifier() {
        return this.getSuperclass().hasEmbeddedIdentifier();
    }

    @Override
    public Class<? extends EntityPersister> getEntityPersisterClass() {
        return this.classPersisterClass == null ? this.getSuperclass().getEntityPersisterClass() : this.classPersisterClass;
    }

    @Override
    public Table getRootTable() {
        return this.getSuperclass().getRootTable();
    }

    @Override
    public KeyValue getKey() {
        return this.getSuperclass().getIdentifier();
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.getSuperclass().isExplicitPolymorphism();
    }

    @Override
    public boolean isConcreteProxy() {
        return this.getRootClass().isConcreteProxy();
    }

    public void setSuperclass(PersistentClass superclass) {
        this.superclass = superclass;
    }

    @Override
    public String getWhere() {
        return this.getSuperclass().getWhere();
    }

    @Override
    public boolean isJoinedSubclass() {
        return this.getTable() != this.getRootTable();
    }

    public void createForeignKey() {
        if (this.isJoinedSubclass()) {
            this.getKey().createForeignKeyOfEntity(this.getSuperclass().getEntityName());
        }
    }

    @Override
    public void setEntityPersisterClass(Class<? extends EntityPersister> classPersisterClass) {
        this.classPersisterClass = classPersisterClass;
    }

    @Override
    public int getJoinClosureSpan() {
        return this.getSuperclass().getJoinClosureSpan() + super.getJoinClosureSpan();
    }

    @Override
    public int getPropertyClosureSpan() {
        return this.getSuperclass().getPropertyClosureSpan() + super.getPropertyClosureSpan();
    }

    @Override
    public List<Join> getJoinClosure() {
        return new JoinedList<Join>(this.getSuperclass().getJoinClosure(), super.getJoinClosure());
    }

    @Override
    public boolean isClassOrSuperclassJoin(Join join) {
        return super.isClassOrSuperclassJoin(join) || this.getSuperclass().isClassOrSuperclassJoin(join);
    }

    @Override
    public boolean isClassOrSuperclassTable(Table table) {
        return super.isClassOrSuperclassTable(table) || this.getSuperclass().isClassOrSuperclassTable(table);
    }

    @Override
    public Table getTable() {
        return this.getSuperclass().getTable();
    }

    @Override
    public boolean isForceDiscriminator() {
        return this.getSuperclass().isForceDiscriminator();
    }

    @Override
    public boolean isDiscriminatorInsertable() {
        return this.getSuperclass().isDiscriminatorInsertable();
    }

    @Override
    public Set<String> getSynchronizedTables() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.synchronizedTables);
        result.addAll(this.getSuperclass().getSynchronizedTables());
        return result;
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }

    @Override
    public List<FilterConfiguration> getFilters() {
        ArrayList<FilterConfiguration> filters = new ArrayList<FilterConfiguration>(super.getFilters());
        filters.addAll(this.getSuperclass().getFilters());
        return filters;
    }

    @Override
    public boolean hasSubselectLoadableCollections() {
        return super.hasSubselectLoadableCollections() || this.getSuperclass().hasSubselectLoadableCollections();
    }

    @Override
    public Component getIdentifierMapper() {
        return this.superclass.getIdentifierMapper();
    }

    @Override
    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.superclass.getOptimisticLockStyle();
    }
}

