/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntitySelectFetchInitializer<Data extends EntitySelectFetchInitializerData>
extends AbstractInitializer<Data>
implements EntityInitializer<Data> {
    protected final InitializerParent<?> parent;
    private final NavigablePath navigablePath;
    private final boolean isPartOfKey;
    private final boolean isEnhancedForLazyLoading;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler<?> keyAssembler;
    protected final ToOneAttributeMapping toOneMapping;
    protected final boolean affectedByFilter;
    protected final boolean keyIsEager;
    protected final boolean hasLazySubInitializer;

    public EntitySelectFetchInitializer(InitializerParent<?> parent, ToOneAttributeMapping toOneMapping, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(creationState);
        this.parent = parent;
        this.toOneMapping = toOneMapping;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parent);
        this.concreteDescriptor = concreteDescriptor;
        this.keyAssembler = keyResult.createResultAssembler(this, creationState);
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        this.affectedByFilter = affectedByFilter;
        Initializer<?> initializer = this.keyAssembler.getInitializer();
        if (initializer == null) {
            this.keyIsEager = false;
            this.hasLazySubInitializer = false;
        } else {
            this.keyIsEager = initializer.isEager();
            this.hasLazySubInitializer = !initializer.isEager() || initializer.hasLazySubInitializers();
        }
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EntitySelectFetchInitializerData(this, rowProcessingState);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.toOneMapping;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveFromPreviousRow(Data data) {
        if (((InitializerData)data).getState() == Initializer.State.UNINITIALIZED) {
            if (((InitializerData)data).getInstance() == null) {
                ((InitializerData)data).setState(Initializer.State.MISSING);
            } else {
                Initializer<?> initializer = this.keyAssembler.getInitializer();
                if (initializer != null) {
                    initializer.resolveFromPreviousRow(((InitializerData)data).getRowProcessingState());
                }
                ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            }
        }
    }

    @Override
    public void resolveInstance(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        ((EntitySelectFetchInitializerData)data).entityIdentifier = this.keyAssembler.assemble(rowProcessingState);
        if (((EntitySelectFetchInitializerData)data).entityIdentifier == null) {
            ((InitializerData)data).setState(Initializer.State.MISSING);
            ((InitializerData)data).setInstance(null);
            return;
        }
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        this.initialize((EntitySelectFetchInitializerData)data);
    }

    @Override
    public void resolveInstance(Object instance, Data data) {
        if (instance == null) {
            ((InitializerData)data).setState(Initializer.State.MISSING);
            ((EntitySelectFetchInitializerData)data).entityIdentifier = null;
            ((InitializerData)data).setInstance(null);
        } else {
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
            if (lazyInitializer == null) {
                ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                ((EntitySelectFetchInitializerData)data).entityIdentifier = this.concreteDescriptor.getIdentifier(instance, session);
            } else if (lazyInitializer.isUninitialized()) {
                ((InitializerData)data).setState(Initializer.State.RESOLVED);
                ((EntitySelectFetchInitializerData)data).entityIdentifier = lazyInitializer.getInternalIdentifier();
            } else {
                ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                ((EntitySelectFetchInitializerData)data).entityIdentifier = lazyInitializer.getInternalIdentifier();
            }
            EntityKey entityKey = new EntityKey(((EntitySelectFetchInitializerData)data).entityIdentifier, this.concreteDescriptor);
            EntityHolder entityHolder = persistenceContext.getEntityHolder(entityKey);
            if (entityHolder == null || entityHolder.getEntity() != instance && entityHolder.getProxy() != instance) {
                if (entityHolder != null) {
                    Object managed = entityHolder.getManagedObject();
                    ((InitializerData)data).setInstance(managed);
                    ((EntitySelectFetchInitializerData)data).entityIdentifier = entityHolder.getEntityKey().getIdentifier();
                    ((InitializerData)data).setState(entityHolder.isInitialized() ? Initializer.State.INITIALIZED : Initializer.State.RESOLVED);
                } else {
                    this.initialize((EntitySelectFetchInitializerData)data, null, session, persistenceContext);
                }
            } else {
                ((InitializerData)data).setInstance(instance);
            }
            if (this.keyIsEager) {
                Initializer<?> initializer = this.keyAssembler.getInitializer();
                assert (initializer != null);
                initializer.resolveInstance(((EntitySelectFetchInitializerData)data).entityIdentifier, rowProcessingState);
            } else if (rowProcessingState.needsResolveState()) {
                this.keyAssembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    public void initializeInstance(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.RESOLVED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        Hibernate.initialize(((InitializerData)data).getInstance());
    }

    protected void initialize(EntitySelectFetchInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityKey entityKey = new EntityKey(data.entityIdentifier, this.concreteDescriptor);
        this.initialize(data, persistenceContext.getEntityHolder(entityKey), session, persistenceContext);
    }

    protected void initialize(EntitySelectFetchInitializerData data, @Nullable EntityHolder holder, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
        if (holder != null) {
            data.setInstance(persistenceContext.proxyFor(holder, this.concreteDescriptor));
            if (holder.getEntityInitializer() == null) {
                if (data.getInstance() != null && Hibernate.isInitialized(data.getInstance())) {
                    data.setState(Initializer.State.INITIALIZED);
                    return;
                }
            } else {
                if (holder.getEntityInitializer() != this) {
                    data.setState(Initializer.State.INITIALIZED);
                    return;
                }
                if (data.getInstance() == null) {
                    assert (holder.getProxy() == null) : "How to handle this case?";
                    data.setState(Initializer.State.INITIALIZED);
                    return;
                }
            }
        }
        data.setState(Initializer.State.INITIALIZED);
        String entityName = this.concreteDescriptor.getEntityName();
        Object instance = session.internalLoad(entityName, data.entityIdentifier, true, this.toOneMapping.isInternalLoadNullable());
        data.setInstance(instance);
        if (instance == null) {
            if (this.toOneMapping.getNotFoundAction() != NotFoundAction.IGNORE) {
                if (this.affectedByFilter) {
                    throw new EntityFilterException(entityName, data.entityIdentifier, this.toOneMapping.getNavigableRole().getFullPath());
                }
                if (this.toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                    throw new FetchNotFoundException(entityName, data.entityIdentifier);
                }
            }
            persistenceContext.claimEntityHolderIfPossible(new EntityKey(data.entityIdentifier, this.concreteDescriptor), null, data.getRowProcessingState().getJdbcValuesSourceProcessingState(), this);
        }
        boolean unwrapProxy = this.toOneMapping.isUnwrapProxy() && this.isEnhancedForLazyLoading;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
        if (lazyInitializer != null) {
            lazyInitializer.setUnwrap(unwrapProxy);
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, Data data) {
        Object instance;
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object object = instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        if (instance == null) {
            ((InitializerData)data).setState(Initializer.State.MISSING);
            ((EntitySelectFetchInitializerData)data).entityIdentifier = null;
            ((InitializerData)data).setInstance(null);
        } else {
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            ((EntitySelectFetchInitializerData)data).entityIdentifier = null;
            ((InitializerData)data).setInstance(instance);
            Hibernate.initialize(instance);
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer = this.keyAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public EntityPersister getConcreteDescriptor(Data data) {
        return this.concreteDescriptor;
    }

    @Override
    public @Nullable Object getEntityIdentifier(Data data) {
        return ((EntitySelectFetchInitializerData)data).entityIdentifier;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public void resolveState(EntitySelectFetchInitializerData data) {
        this.keyAssembler.resolveState(data.getRowProcessingState());
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializer;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    public DomainResultAssembler<?> getKeyAssembler() {
        return this.keyAssembler;
    }

    public static class EntitySelectFetchInitializerData
    extends InitializerData {
        protected @Nullable Object entityIdentifier;

        public EntitySelectFetchInitializerData(EntitySelectFetchInitializer<?> initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }

        public EntitySelectFetchInitializerData(EntitySelectFetchInitializerData original) {
            super(original);
            this.entityIdentifier = original.entityIdentifier;
        }
    }
}

