/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.context.extensions.boot.actuator;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.Assert;

public class WicketAutoConfig
implements Serializable {
    private final String key;
    private final Map<String, Object> details;

    private WicketAutoConfig(Builder builder) {
        Assert.notNull((Object)builder, (String)"Builder must not be null");
        this.key = builder.configurationClass != null ? builder.configurationClass.getSimpleName() : null;
        this.details = Collections.unmodifiableMap(builder.details);
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Map<String, Object> getDetails() {
        return this.details;
    }

    public static class Builder {
        private final Class<?> configurationClass;
        private Map<String, Object> details;

        public Builder() {
            this.configurationClass = null;
            this.details = new LinkedHashMap<String, Object>();
        }

        public Builder(Class<?> configurationClass) {
            Assert.notNull(configurationClass, (String)"ConfigurationClass must not be null");
            this.configurationClass = configurationClass;
            this.details = new LinkedHashMap<String, Object>();
        }

        public Builder(Class<?> configurationClass, Map<String, ?> details) {
            Assert.notNull(configurationClass, (String)"ConfigurationClass must not be null");
            Assert.notNull(details, (String)"Details must not be null");
            this.configurationClass = configurationClass;
            this.details = new LinkedHashMap(details);
        }

        public Builder withDetail(String key, Object value) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            this.details.put(key, value);
            return this;
        }

        public WicketAutoConfig build() {
            return new WicketAutoConfig(this);
        }
    }
}

