/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class EventGatewayValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List eventGateways = process.findFlowElementsOfType(EventGateway.class);
        for (EventGateway eventGateway : eventGateways) {
            for (SequenceFlow sequenceFlow : eventGateway.getOutgoingFlows()) {
                FlowElement flowElement = process.getFlowElement(sequenceFlow.getTargetRef(), true);
                if (flowElement == null || flowElement instanceof IntermediateCatchEvent) continue;
                this.addError(errors, "flowable-event-gateway-only-connected-to-intermediate-events", process, (BaseElement)eventGateway, "Event based gateway can only be connected to elements of type intermediateCatchEvent");
            }
        }
    }
}

