/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.metadata.AzureAdOpMetadataResolver;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;

public class AzureAd2OidcConfiguration
extends OidcConfiguration {
    private String tenant;

    public AzureAd2OidcConfiguration() {
    }

    public AzureAd2OidcConfiguration(OidcConfiguration oidcConfiguration) {
        this.setOpMetadataResolver(oidcConfiguration.getOpMetadataResolver());
        this.setClientId(oidcConfiguration.getClientId());
        this.setSecret(oidcConfiguration.getSecret());
        this.setScope(oidcConfiguration.getScope());
        this.setCustomParams(oidcConfiguration.getCustomParams());
        this.setClientAuthenticationMethod(oidcConfiguration.getClientAuthenticationMethod());
        this.setUseNonce(oidcConfiguration.isUseNonce());
        this.setPreferredJwsAlgorithm(oidcConfiguration.getPreferredJwsAlgorithm());
        this.setMaxClockSkew(oidcConfiguration.getMaxClockSkew());
        this.setConnectTimeout(oidcConfiguration.getConnectTimeout());
        this.setReadTimeout(oidcConfiguration.getReadTimeout());
        this.setDiscoveryURI(oidcConfiguration.getDiscoveryURI());
        this.setResourceRetriever(oidcConfiguration.getResourceRetriever());
        this.setResponseType(oidcConfiguration.getResponseType());
        this.setResponseMode(oidcConfiguration.getResponseMode());
        this.setLogoutUrl(oidcConfiguration.getLogoutUrl());
        if (oidcConfiguration instanceof AzureAd2OidcConfiguration) {
            AzureAd2OidcConfiguration azureAd2OidcConfiguration = (AzureAd2OidcConfiguration)oidcConfiguration;
            this.setTenant(azureAd2OidcConfiguration.getTenant());
        }
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        if (StringUtils.isBlank((CharSequence)this.getTenant())) {
            this.setTenant("common");
        }
        super.internalInit(forceReinit);
    }

    @Override
    protected OidcOpMetadataResolver createNewOpMetadataResolver() {
        return new AzureAdOpMetadataResolver(this);
    }

    @Override
    public String getDiscoveryURI() {
        return "https://login.microsoftonline.com/" + this.getTenant() + "/v2.0/.well-known/openid-configuration";
    }

    public String makeOauth2TokenRequest(String refreshToken) {
        String scope = this.getScope();
        if (StringUtils.isBlank((CharSequence)scope)) {
            scope = "openid profile email";
        }
        String payload = HttpUtils.encodeQueryParam((String)"client_id", (String)this.getClientId()) + "&" + HttpUtils.encodeQueryParam((String)"client_secret", (String)this.getSecret()) + "&" + HttpUtils.encodeQueryParam((String)"grant_type", (String)"refresh_token") + "&" + HttpUtils.encodeQueryParam((String)"refresh_token", (String)refreshToken) + "&" + HttpUtils.encodeQueryParam((String)"tenant", (String)this.getTenant()) + "&" + HttpUtils.encodeQueryParam((String)"scope", (String)scope);
        return payload;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AzureAd2OidcConfiguration(super=" + super.toString() + ", tenant=" + this.tenant + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AzureAd2OidcConfiguration setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AzureAd2OidcConfiguration withTenant(String tenant) {
        return this.tenant == tenant ? this : new AzureAd2OidcConfiguration(tenant);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AzureAd2OidcConfiguration(String tenant) {
        this.tenant = tenant;
    }
}

