/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.pm.RestfulPasswordManagementProperties;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.rest.RestPasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagement}, module="rest")
@AutoConfiguration
public class CasRestPasswordManagementAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasRestPasswordManagementAutoConfiguration.class);

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"restPasswordChangeService"})
    public PasswordManagementService passwordChangeService(@Qualifier(value="passwordChangeServiceRestTemplate") RestTemplate passwordChangeServiceRestTemplate, CasConfigurationProperties casProperties, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
        return new RestPasswordManagementService((CipherExecutor<Serializable, String>)passwordManagementCipherExecutor, casProperties, passwordChangeServiceRestTemplate, passwordHistoryService);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"passwordChangeServiceRestTemplate"})
    public RestTemplate passwordChangeServiceRestTemplate(CasConfigurationProperties casProperties) {
        RestfulPasswordManagementProperties pmRest = casProperties.getAuthn().getPm().getRest();
        String username = pmRest.getEndpointUsername();
        String password = pmRest.getEndpointPassword();
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)username) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)password)) {
            LOGGER.debug("Configuring basic authentication for password management via REST for [{}]", (Object)username);
            builder = builder.basicAuthentication(username, password, StandardCharsets.UTF_8);
        }
        builder = builder.defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Accept-Charset", new String[]{StandardCharsets.UTF_8.name()});
        for (Map.Entry entry : pmRest.getHeaders().entrySet()) {
            LOGGER.debug("Configuring header [{}] with value [{}]", entry.getKey(), entry.getValue());
            builder = builder.defaultHeader((String)entry.getKey(), StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue())));
        }
        return builder.build();
    }
}

