/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.web.LocaleCookieProperties;
import org.apereo.cas.configuration.model.core.web.LocaleProperties;
import org.apereo.cas.util.spring.RefreshableHandlerInterceptor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.ThemeChangeInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.mvc.UrlFilenameViewController;
import org.springframework.web.servlet.view.RedirectView;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebApplication})
@Configuration(value="CasWebAppConfiguration", proxyBeanMethods=false)
class CasWebAppConfiguration {
    CasWebAppConfiguration() {
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"casThemeChangeInterceptor"})
    public HandlerInterceptor themeChangeInterceptor(@Qualifier(value="themeResolver") ThemeResolver themeResolver, CasConfigurationProperties casProperties) {
        return new ThemeChangeInterceptor(themeResolver, casProperties.getTheme().getParamName());
    }

    @Configuration(value="CasWebAppControllersConfiguration", proxyBeanMethods=false)
    static class CasWebAppControllersConfiguration {
        CasWebAppControllersConfiguration() {
        }

        @Bean
        public SimpleUrlHandlerMapping handlerMapping() {
            SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
            mapping.setOrder(1);
            mapping.getUrlPathHelper().setAlwaysUseFullPath(true);
            HashMap<String, RootController> urls = new HashMap<String, RootController>();
            RootController rootController = new RootController();
            mapping.setRootHandler((Object)rootController);
            urls.put("/", rootController);
            mapping.setUrlMap(urls);
            return mapping;
        }

        @Bean
        public UrlFilenameViewController passThroughController() {
            return new UrlFilenameViewController();
        }

        private static final class RootController
        extends ParameterizableViewController {
            private RootController() {
            }

            protected ModelAndView handleRequestInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
                String queryString = request.getQueryString();
                String url = request.getContextPath() + "/login" + Optional.ofNullable(queryString).map(value -> "?" + value).orElse("");
                return new ModelAndView((View)new RedirectView(response.encodeURL(url)));
            }
        }
    }

    @Configuration(value="CasWebAppLocaleConfiguration", proxyBeanMethods=false)
    static class CasWebAppLocaleConfiguration {
        CasWebAppLocaleConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casLocaleResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LocaleResolver localeResolver(CasConfigurationProperties casProperties) {
            LocaleProperties localeProps = casProperties.getLocale();
            LocaleCookieProperties localeCookie = localeProps.getCookie();
            String cookieName = (String)StringUtils.defaultIfBlank((CharSequence)localeCookie.getName(), (CharSequence)CookieLocaleResolver.DEFAULT_COOKIE_NAME);
            CookieLocaleResolver resolver = new CookieLocaleResolver(cookieName);
            resolver.setDefaultLocaleFunction(request -> {
                Locale locale = request.getLocale();
                if (StringUtils.isBlank((CharSequence)localeProps.getDefaultValue()) || !locale.getLanguage().equals(localeProps.getDefaultValue())) {
                    return locale;
                }
                return Locale.forLanguageTag(localeProps.getDefaultValue());
            });
            resolver.setCookieDomain(localeCookie.getDomain());
            resolver.setCookiePath((String)StringUtils.defaultIfBlank((CharSequence)localeCookie.getPath(), (CharSequence)"/"));
            resolver.setCookieHttpOnly(localeCookie.isHttpOnly());
            resolver.setCookieSecure(localeCookie.isSecure());
            resolver.setCookieMaxAge(Duration.ofSeconds(CookieUtils.getCookieMaxAge((String)localeCookie.getMaxAge())));
            resolver.setLanguageTagCompliant(true);
            resolver.setRejectInvalidCookies(true);
            return resolver;
        }

        @Bean
        public WebMvcConfigurer casWebAppWebMvcConfigurer(final @Qualifier(value="localeChangeInterceptor") ObjectProvider<HandlerInterceptor> localeChangeInterceptor) {
            return new WebMvcConfigurer(){

                public void addInterceptors(@Nonnull InterceptorRegistry registry) {
                    RefreshableHandlerInterceptor interceptor = new RefreshableHandlerInterceptor(localeChangeInterceptor);
                    registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{"/**"});
                }
            };
        }
    }
}

