/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNonInteractiveCredentialsAction.class);
    private static final String AUTHN_FAILURE_MESSAGE_CODE = "authenticationFailure.FailedLoginException";

    protected AbstractNonInteractiveCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
    }

    @Override
    protected Event doPreExecute(RequestContext context) throws Exception {
        Credential credential = this.constructCredentialsFromRequest(context);
        if (credential == null) {
            LOGGER.info("No credentials could be extracted/detected from the current request");
            return this.error();
        }
        WebUtils.putCredential((RequestContext)context, (Credential)credential);
        return super.doPreExecute(context);
    }

    @Override
    protected void onError(RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)AUTHN_FAILURE_MESSAGE_CODE);
    }

    protected abstract Credential constructCredentialsFromRequest(RequestContext var1);
}

