/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.states;

import java.lang.reflect.Field;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.webflow.action.ExternalRedirectAction;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class EndViewState
extends ViewState {
    private boolean forceRenderView;

    public EndViewState(Flow flow, String id, ViewFactory viewFactory) {
        super(flow, id, viewFactory);
    }

    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        try {
            super.doEnter(context);
            if (this.shouldRenderView((RequestContext)context)) {
                View view = this.getViewFactory().getView((RequestContext)context);
                context.setCurrentView(view);
                context.viewRendering(view);
                this.getRenderActionList().execute((RequestContext)context);
                FunctionUtils.doAndHandle(__ -> view.render());
                context.getFlashScope().clear();
                context.getMessageContext().clearMessages();
                context.getExternalContext().recordResponseComplete();
                context.viewRendered(view);
            }
        }
        finally {
            context.endActiveFlowSession(this.getId(), (MutableAttributeMap)new LocalAttributeMap());
        }
    }

    protected boolean shouldRenderView(RequestContext context) {
        if (this.forceRenderView) {
            Field field = ReflectionUtils.findField((Class)context.getCurrentView().getClass(), (String)"action");
            if (field != null) {
                field.trySetAccessible();
                Action action = (Action)ReflectionUtils.getField((Field)field, (Object)context.getCurrentView());
                return !(action instanceof ExternalRedirectAction);
            }
            return true;
        }
        return false;
    }

    @Generated
    public void setForceRenderView(boolean forceRenderView) {
        this.forceRenderView = forceRenderView;
    }
}

