/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="MailTemplates")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="mailTemplates")
public interface MailTemplateService
extends JAXRSService {
    @GET
    @Produces(value={"application/json"})
    public List<MailTemplateTO> list();

    @ApiResponses(value={@ApiResponse(responseCode="201", description="MailTemplate successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key value for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@NotNull MailTemplateTO var1);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public MailTemplateTO read(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @GET
    @Path(value="{key}/{format}")
    public Response getFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") MailTemplateFormat var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}/{format}")
    @Produces(value={"application/json"})
    public void setFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") MailTemplateFormat var2, InputStream var3);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}/{format}")
    @Produces(value={"application/json"})
    public void removeFormat(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="format") MailTemplateFormat var2);
}

