/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.authprofiles;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.authprofiles.AuthProfileWizardBuilder;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AuthProfileRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class AuthProfileItemDirectoryPanel<I extends BaseBean>
extends DirectoryPanel<I, I, AuthProfileItemProvider, AuthProfileRestClient> {
    private static final long serialVersionUID = 7640851594812655896L;
    protected final BaseModal<AuthProfileTO> authProfileModal;
    protected final AuthProfileTO authProfile;

    public AuthProfileItemDirectoryPanel(String id, AuthProfileRestClient restClient, BaseModal<AuthProfileTO> authProfileModal, AuthProfileTO authProfile, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, false);
        this.authProfileModal = authProfileModal;
        this.authProfile = authProfile;
        this.setOutputMarkupId(true);
        this.enableUtilityButton();
        this.setFooterVisibility(false);
        this.disableCheckBoxes();
        this.initResultTable();
    }

    protected abstract List<I> getItems();

    protected abstract I defaultItem();

    protected abstract String sortProperty();

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof WizardMgtPanel.ExitEvent) {
            WizardMgtPanel.ExitEvent exitEvent = (WizardMgtPanel.ExitEvent)object;
            this.authProfileModal.close((IPartialPageRequestHandler)exitEvent.getTarget());
        } else {
            object = event.getPayload();
            if (object instanceof AjaxWizard.EditItemActionEvent) {
                AjaxWizard.EditItemActionEvent payload = (AjaxWizard.EditItemActionEvent)object;
                payload.getTarget().ifPresent(arg_0 -> ((ActionLinksTogglePanel)this.actionTogglePanel).close(arg_0));
            }
        }
        super.onEvent(event);
    }

    protected AuthProfileItemProvider dataProvider() {
        return new AuthProfileItemProvider(this.sortProperty(), this.rows);
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public ActionsPanel<I> getActions(final IModel<I> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add(new ActionLink<I>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AuthProfileItemDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, I ignore) {
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((BaseBean)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "AUTH_PROFILE_UPDATE");
        panel.add(new ActionLink<I>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AuthProfileItemDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, I ignore) {
                try {
                    this.this$0.getItems().remove(model.getObject());
                    ((AuthProfileRestClient)this.this$0.restClient).update(this.this$0.authProfile);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (Exception e) {
                    LOG.error("While deleting {} from {}", new Object[]{model.getObject(), this.this$0.authProfile.getKey(), e});
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "AUTH_PROFILE_UPDATE", true);
        return panel;
    }

    protected class AuthProfileItemProvider
    extends DirectoryDataProvider<I> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<I> comparator;

        AuthProfileItemProvider(String sort, int paginatorRows) {
            super(paginatorRows);
            this.setSort(sort, SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<I> iterator(long first, long count) {
            List list = AuthProfileItemDirectoryPanel.this.getItems();
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return AuthProfileItemDirectoryPanel.this.getItems().size();
        }

        public IModel<I> model(I object) {
            return new CompoundPropertyModel(object);
        }
    }

    protected class AuthProfileItemWizardBuilder
    extends AuthProfileWizardBuilder<I> {
        private static final long serialVersionUID = -7174537333960225216L;

        protected AuthProfileItemWizardBuilder(PageReference pageRef) {
            super(AuthProfileItemDirectoryPanel.this.defaultItem(), new AuthProfileWizardBuilder.StepModel(), pageRef);
        }

        protected Serializable onApplyInternal(I modelObject) {
            BeanWrapper wrapper;
            List values;
            if (modelObject instanceof GoogleMfaAuthAccount && (values = (List)(wrapper = PropertyAccessorFactory.forBeanPropertyAccess(modelObject)).getPropertyValue("scratchCodes")) != null) {
                List converted = values.stream().map(value -> {
                    if (value instanceof Integer) {
                        Integer integer = (Integer)value;
                        return integer;
                    }
                    if (value instanceof String) {
                        String string = (String)((Object)value);
                        try {
                            return Integer.valueOf(string);
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to Integer: {}", value, (Object)e);
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                wrapper.setPropertyValue("scratchCodes", converted);
            }
            AuthProfileItemDirectoryPanel.this.getItems().remove(this.model.getInitialModelObject());
            AuthProfileItemDirectoryPanel.this.getItems().add(modelObject);
            ((AuthProfileRestClient)AuthProfileItemDirectoryPanel.this.restClient).update(AuthProfileItemDirectoryPanel.this.authProfile);
            return modelObject;
        }
    }
}

