/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AttrRepoRestClient;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AttrRepoWizardBuilder;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AttrRepoDirectoryPanel
extends DirectoryPanel<AttrRepoTO, AttrRepoTO, AttrRepoProvider, AttrRepoRestClient> {
    private static final long serialVersionUID = 1005345990563741296L;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final BaseModal<Serializable> historyModal;

    public AttrRepoDirectoryPanel(String id, AttrRepoRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.disableCheckBoxes();
        this.addNewItemPanelBuilder((ModalPanelBuilder)new AttrRepoWizardBuilder(new AttrRepoTO(), restClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"ATTR_REPO_CREATE");
        this.modal.size(Modal.Size.Extra_large);
        this.initResultTable();
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    protected AttrRepoProvider dataProvider() {
        return new AttrRepoProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "authmodule.paginator.rows";
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected List<IColumn<AttrRepoTO, String>> getColumns() {
        ArrayList<IColumn<AttrRepoTO, String>> columns = new ArrayList<IColumn<AttrRepoTO, String>>();
        columns.add((IColumn<AttrRepoTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<AttrRepoTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((IColumn<AttrRepoTO, String>)new PropertyColumn<AttrRepoTO, String>((IModel)new ResourceModel("type"), "conf"){
            private static final long serialVersionUID = -1822504503325964706L;

            public void populateItem(Item<ICellPopulator<AttrRepoTO>> item, String componentId, IModel<AttrRepoTO> rowModel) {
                item.add(new Component[]{new Label(componentId, (Serializable)((Object)(((AttrRepoTO)rowModel.getObject()).getConf() == null ? "" : StringUtils.substringBefore((String)((AttrRepoTO)rowModel.getObject()).getConf().getClass().getSimpleName(), (String)"AttrRepoConf"))))});
            }
        });
        columns.add((IColumn<AttrRepoTO, String>)new PropertyColumn((IModel)new ResourceModel("state"), (Object)"state", "state"));
        columns.add((IColumn<AttrRepoTO, String>)new PropertyColumn((IModel)new ResourceModel("order"), (Object)"order", "order"));
        return columns;
    }

    public ActionsPanel<AttrRepoTO> getActions(final IModel<AttrRepoTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<AttrRepoTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AttrRepoDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AttrRepoTO ignore) {
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((AttrRepoRestClient)this.this$0.restClient).read(((AttrRepoTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "ATTR_REPO_UPDATE");
        panel.add((ActionLink)new ActionLink<AttrRepoTO>(this){
            private static final long serialVersionUID = -5432034353017728756L;
            final /* synthetic */ AttrRepoDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AttrRepoTO ignore) {
                model.setObject((Object)((AttrRepoRestClient)this.this$0.restClient).read(((AttrRepoTO)model.getObject()).getKey()));
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<AttrRepoTO>(this, OpEvent.CategoryType.LOGIC, "AttrRepoLogic", (AttrRepoTO)model.getObject(), "ATTR_REPO_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033822L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            AttrRepoTO updated = (AttrRepoTO)DirectoryPanel.MAPPER.readValue(json, AttrRepoTO.class);
                            ((AttrRepoRestClient)this.this$1.this$0.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring AttrRepo {}", (Object)((AttrRepoTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.this$1.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)this.this$0.getString("auditHistory.title", (IModel)new Model((Serializable)((AttrRepoTO)model.getObject()))))));
                this.this$0.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "ATTR_REPO_READ", "AUDIT_LIST"));
        panel.add((ActionLink)new ActionLink<AttrRepoTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ AttrRepoDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, AttrRepoTO ignore) {
                try {
                    ((AttrRepoRestClient)this.this$0.restClient).delete(((AttrRepoTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((AttrRepoTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "ATTR_REPO_DELETE", true);
        return panel;
    }

    protected final class AttrRepoProvider
    extends DirectoryDataProvider<AttrRepoTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AttrRepoTO> comparator;

        private AttrRepoProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<AttrRepoTO> iterator(long first, long count) {
            List<AttrRepoTO> attrRepos = ((AttrRepoRestClient)AttrRepoDirectoryPanel.this.restClient).list();
            attrRepos.sort((Comparator<AttrRepoTO>)this.comparator);
            return attrRepos.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((AttrRepoRestClient)AttrRepoDirectoryPanel.this.restClient).list().size();
        }

        public IModel<AttrRepoTO> model(AttrRepoTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

