/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.rest.SRAStatistics;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SRAStatisticsRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(SRAStatisticsRestClient.class);
    private static final List<?> JAX_RS_PROVIDERS = List.of(new JacksonJsonProvider(((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build()));

    protected String getActuatorEndpoint(List<NetworkService> instances) {
        return instances.getFirst().getAddress() + "actuator/metrics/spring.cloud.gateway.requests";
    }

    public SRAStatistics get(List<NetworkService> instances, List<Pair<String, String>> selected) {
        try {
            Response response;
            WebClient client = WebClient.create((String)this.getActuatorEndpoint(instances), JAX_RS_PROVIDERS, (String)SyncopeWebApplication.get().getAnonymousUser(), (String)SyncopeWebApplication.get().getAnonymousKey(), null).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            if (!selected.isEmpty()) {
                client.query("tag", selected.stream().map(s -> (String)s.getLeft() + ":" + (String)s.getRight()).toArray());
            }
            if ((response = client.get()).getStatus() == Response.Status.OK.getStatusCode()) {
                return (SRAStatistics)response.readEntity(SRAStatistics.class);
            }
            LOG.error("Unexpected response for SRA statistics from {}: {}", (Object)this.getActuatorEndpoint(instances), (Object)response.getStatus());
        }
        catch (Exception e) {
            LOG.error("Could not fetch SRA statistics from {}", (Object)this.getActuatorEndpoint(instances), (Object)e);
        }
        return new SRAStatistics();
    }
}

