/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategyConflictResolver;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStoreConfigurer;
import org.apereo.cas.authentication.attribute.DefaultAttributeDefinitionStore;
import org.apereo.cas.authentication.principal.ChainingPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.DefaultPrincipalResolutionExecutionPlan;
import org.apereo.cas.authentication.principal.PrincipalElectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlan;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.resolvers.ChainingPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.EchoingPrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication})
@Configuration(value="CasCoreAuthenticationPrincipalConfiguration", proxyBeanMethods=false)
class CasCoreAuthenticationPrincipalConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationPrincipalConfiguration.class);

    CasCoreAuthenticationPrincipalConfiguration() {
    }

    @Configuration(value="CasCoreAuthenticationAttributeDefinitionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationAttributeDefinitionConfiguration {
        CasCoreAuthenticationAttributeDefinitionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"attributeDefinitionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AttributeDefinitionStore attributeDefinitionStore(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            Collection builders = applicationContext.getBeansOfType(AttributeDefinitionStoreConfigurer.class).values();
            DefaultAttributeDefinitionStore store = new DefaultAttributeDefinitionStore(new AttributeDefinition[0]);
            store.setScope(casProperties.getServer().getScope());
            builders.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<AttributeDefinitionStoreConfigurer>)AnnotationAwareOrderComparator.INSTANCE).map(AttributeDefinitionStoreConfigurer::load).forEach(arg_0 -> ((DefaultAttributeDefinitionStore)store).registerAttributeDefinitions(arg_0));
            Resource resource = casProperties.getAuthn().getAttributeRepository().getAttributeDefinitionStore().getJson().getLocation();
            store.importStore(resource);
            store.watchStore(resource);
            return store;
        }
    }

    @Configuration(value="CasCoreAuthenticationPrincipalFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationPrincipalFactoryConfiguration {
        CasCoreAuthenticationPrincipalFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"principalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory principalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"globalPrincipalAttributeRepository"})
        public RegisteredServicePrincipalAttributesRepository globalPrincipalAttributeRepository(CasConfigurationProperties casProperties) {
            PrincipalAttributesCoreProperties props = casProperties.getAuthn().getAttributeRepository().getCore();
            int cacheTime = props.getExpirationTime();
            if (cacheTime <= 0) {
                LOGGER.warn("Caching for the global principal attribute repository is disabled");
                return new DefaultPrincipalAttributesRepository();
            }
            return new CachingPrincipalAttributesRepository(props.getExpirationTimeUnit().toUpperCase(Locale.ENGLISH), (long)cacheTime);
        }
    }

    @Configuration(value="CasCoreAuthenticationPrincipalElectionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationPrincipalElectionConfiguration {
        CasCoreAuthenticationPrincipalElectionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"principalElectionStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalElectionStrategy principalElectionStrategy(List<PrincipalElectionStrategyConfigurer> configurers, @Qualifier(value="principalElectionAttributeMerger") AttributeMerger attributeMerger) {
            LOGGER.trace("Building principal election strategies from [{}]", configurers);
            ChainingPrincipalElectionStrategy chain = new ChainingPrincipalElectionStrategy(new PrincipalElectionStrategy[0]);
            chain.setAttributeMerger(attributeMerger);
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            configurers.forEach(c -> {
                LOGGER.trace("Configuring principal selection strategy: [{}]", c);
                c.configurePrincipalElectionStrategy(chain);
            });
            return chain;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"principalElectionAttributeMerger"})
        public AttributeMerger principalElectionAttributeMerger(CasConfigurationProperties casProperties) {
            return CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
        }

        @ConditionalOnMissingBean(name={"defaultPrincipalElectionStrategyConflictResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalElectionStrategyConflictResolver defaultPrincipalElectionStrategyConflictResolver(CasConfigurationProperties casProperties) {
            return CoreAuthenticationUtils.newPrincipalElectionStrategyConflictResolver((PersonDirectoryPrincipalResolverProperties)casProperties.getPersonDirectory());
        }

        @ConditionalOnMissingBean(name={"defaultPrincipalElectionStrategyConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalElectionStrategyConfigurer defaultPrincipalElectionStrategyConfigurer(@Qualifier(value="defaultPrincipalElectionStrategyConflictResolver") PrincipalElectionStrategyConflictResolver defaultPrincipalElectionStrategyConflictResolver, @Qualifier(value="principalElectionAttributeMerger") AttributeMerger attributeMerger, CasConfigurationProperties casProperties, @Qualifier(value="principalFactory") PrincipalFactory principalFactory) {
            return chain -> {
                DefaultPrincipalElectionStrategy strategy = new DefaultPrincipalElectionStrategy(principalFactory, defaultPrincipalElectionStrategyConflictResolver);
                strategy.setAttributeMerger(attributeMerger);
                chain.registerElectionStrategy((PrincipalElectionStrategy)strategy);
            };
        }
    }

    @Configuration(value="CasCoreAuthenticationPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuthenticationPrincipalResolutionConfiguration {
        CasCoreAuthenticationPrincipalResolutionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultPrincipalResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver defaultPrincipalResolver(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, List<PrincipalResolutionExecutionPlanConfigurer> configurers, CasConfigurationProperties casProperties, @Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy) {
            DefaultPrincipalResolutionExecutionPlan plan = new DefaultPrincipalResolutionExecutionPlan();
            ArrayList<PrincipalResolutionExecutionPlanConfigurer> sortedConfigurers = new ArrayList<PrincipalResolutionExecutionPlanConfigurer>(configurers);
            AnnotationAwareOrderComparator.sortIfNecessary(sortedConfigurers);
            sortedConfigurers.forEach(Unchecked.consumer(cfg -> {
                LOGGER.trace("Configuring principal resolution execution plan [{}]", (Object)cfg.getName());
                cfg.configurePrincipalResolutionExecutionPlan((PrincipalResolutionExecutionPlan)plan);
            }));
            plan.registerPrincipalResolver((PrincipalResolver)new EchoingPrincipalResolver());
            List registeredPrincipalResolvers = plan.getRegisteredPrincipalResolvers();
            return new ChainingPrincipalResolver(principalElectionStrategy, tenantExtractor, registeredPrincipalResolvers, casProperties);
        }
    }
}

