/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response.soap;

import java.util.Objects;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.SamlProfileSamlResponseBuilderConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.response.soap.SamlProfileSamlSoap11ResponseBuilder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultActor;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;

public class SamlProfileSamlSoap11FaultResponseBuilder
extends SamlProfileSamlSoap11ResponseBuilder {
    public SamlProfileSamlSoap11FaultResponseBuilder(SamlProfileSamlResponseBuilderConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    public Envelope build(SamlProfileBuilderContext context) throws Exception {
        Body body = (Body)SamlUtils.newSoapObject(Body.class);
        Fault fault = (Fault)SamlUtils.newSoapObject(Fault.class);
        FaultCode faultCode = (FaultCode)SamlUtils.newSoapObject(FaultCode.class);
        faultCode.setValue(FaultCode.SERVER);
        fault.setCode(faultCode);
        FaultActor faultActor = (FaultActor)SamlUtils.newSoapObject(FaultActor.class);
        faultActor.setURI(SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)context.getSamlRequest()));
        fault.setActor(faultActor);
        FaultString faultString = (FaultString)SamlUtils.newSoapObject(FaultString.class);
        Object error = context.getHttpRequest().getAttribute("samlError");
        if (error != null) {
            faultString.setValue(error.toString());
        } else {
            faultString.setValue("SOAP failure");
        }
        fault.setMessage(faultString);
        body.getUnknownXMLObjects().add(fault);
        Envelope envelope = (Envelope)SamlUtils.newSoapObject(Envelope.class);
        Header header = (Header)SamlUtils.newSoapObject(Header.class);
        envelope.setHeader(header);
        envelope.setBody(body);
        SOAP11Context ctx = (SOAP11Context)context.getMessageContext().ensureSubcontext(SOAP11Context.class);
        Objects.requireNonNull(ctx).setHTTPResponseStatus(Integer.valueOf(200));
        this.encodeFinalResponse(context, envelope);
        context.getHttpRequest().setAttribute(FaultString.class.getSimpleName(), error);
        return envelope;
    }
}

