/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.FetcherThreadTestUtils$;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.MockFetcherThread;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019\u0019\u0007\u0001)A\u0005\u0015\"9A\r\u0001b\u0001\n\u0003)\u0007BB5\u0001A\u0003%a\rC\u0004k\u0001\t\u0007I\u0011B6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u001d\u0001\bA1A\u0005\n-Da!\u001d\u0001!\u0002\u0013a\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000ba\u0004A\u0011A=\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!1\u0011q\u0006\u0001\u0005\u0002eDa!!\u000f\u0001\t\u0003I\bBBA\u001f\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002B\u0001!\t!\u001f\u0005\u0007\u0003\u000b\u0002A\u0011A=\t\r\u0005%\u0003\u0001\"\u0001z\u0011\u0019\ti\u0005\u0001C\u0001s\"1\u0011\u0011\u000b\u0001\u0005\u0002eDa!!\u0016\u0001\t\u0003I\bBBA-\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002^\u0001!\t!\u001f\u0005\u0007\u0003C\u0002A\u0011A=\t\r\u0005\u0015\u0004\u0001\"\u0001z\u0011\u0019\tI\u0007\u0001C\u0001s\"1\u0011Q\u000e\u0001\u0005\u0002eDa!!\u001d\u0001\t\u0003I\bBBA;\u0001\u0011\u0005\u0011\u0010\u0003\u0004\u0002z\u0001!\t!\u001f\u0005\u0007\u0003{\u0002A\u0011A=\t\r\u0005\u0005\u0005\u0001\"\u0001z\u0011\u0019\t)\t\u0001C\u0001s\"1\u0011\u0011\u0012\u0001\u0005\u0002eDa!!$\u0001\t\u0003I\bbBAI\u0001\u0011%\u00111\u0013\u0005\u0007\u0003?\u0003A\u0011A=\t\r\u0005\r\u0006\u0001\"\u0001z\u0011\u0019\t9\u000b\u0001C\u0001s\"1\u00111\u0016\u0001\u0005\u0002eDq!a,\u0001\t\u0013\t\t\f\u0003\u0004\u0002>\u0002!\t!\u001f\u0005\u0007\u0003\u0003\u0004A\u0011A=\t\r\u0005\u0015\u0007\u0001\"\u0001z\u0011\u0019\tI\r\u0001C\u0001s\nI\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$G+Z:u\u0015\t\u0019D'\u0001\u0004tKJ4XM\u001d\u0006\u0002k\u0005)1.\u00194lC\u000e\u00011C\u0001\u00019!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0011\t\u0003\u0003\u0002i\u0011AM\u0001\u0010iJ,hnY1uK>sg)\u001a;dQV\tA\t\u0005\u0002:\u000b&\u0011aI\u000f\u0002\b\u0005>|G.Z1o\u0003A!(/\u001e8dCR,wJ\u001c$fi\u000eD\u0007%\u0001\u0005u_BL7-\u00133t+\u0005Q\u0005\u0003B&O!bk\u0011\u0001\u0014\u0006\u0003\u001bj\n!bY8mY\u0016\u001cG/[8o\u0013\tyEJA\u0002NCB\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0004TiJLgn\u001a\t\u00033\u0006l\u0011A\u0017\u0006\u00037r\u000baaY8n[>t'BA\u001b^\u0015\tqv,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0006\u0019qN]4\n\u0005\tT&\u0001B+vS\u0012\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u000fY,'o]5p]V\ta\r\u0005\u0002:O&\u0011\u0001N\u000f\u0002\u0006'\"|'\u000f^\u0001\tm\u0016\u00148/[8oA\u0005Q\u0001/\u0019:uSRLwN\\\u0019\u0016\u00031\u0004\"!W7\n\u00059T&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\fa\u0006\u0014H/\u001b;j_:\f\u0004%\u0001\u0006qCJ$\u0018\u000e^5p]J\n1\u0002]1si&$\u0018n\u001c83A\u0005\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0002iB\u0011\u0011)^\u0005\u0003mJ\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\ndY\u0016\fg.T3ue&\u001c'+Z4jgR\u0014\u0018\u0010F\u0001{!\tI40\u0003\u0002}u\t!QK\\5uQ\tqa\u0010E\u0002\u0000\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0004CBL'\u0002BA\u0004\u0003\u0013\tqA[;qSR,'OC\u0002\u0002\f}\u000bQA[;oSRLA!a\u0004\u0002\u0002\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001f\u0005dG.T3ue&\u001c7OT1nKN,\"!!\u0006\u0011\u000b-\u000b9\"a\u0007\n\u0007\u0005eAJA\u0002TKR\u0004B!!\b\u0002,9!\u0011qDA\u0014!\r\t\tCO\u0007\u0003\u0003GQ1!!\n7\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0006\u001e\u0002\rA\u0013X\rZ3g\u0013\r9\u0016Q\u0006\u0006\u0004\u0003SQ\u0014\u0001\b;fgRlU\r\u001e:jGN\u0014V-\\8wK\u0012|en\u00155vi\u0012|wO\u001c\u0015\u0004!\u0005M\u0002cA@\u00026%!\u0011qGA\u0001\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^\"p]N,X.\u001a:MC\u001e\u0014V-\\8wK\u0012<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\"\u001a\u0011#a\r\u0002\u001fQ,7\u000f^*j[BdWMR3uG\"D3AEA\u001a\u0003%!Xm\u001d;EK2\f\u0017\u0010K\u0002\u0014\u0003g\tQ\u0003^3tiB\u000b'\u000f^5uS>t7/\u00138FeJ|'\u000fK\u0002\u0015\u0003g\tA\u0003^3ti\u001a+gnY3e)J,hnY1uS>t\u0007fA\u000b\u00024\u0005yA/Z:u\r\u0016t7-\u001a3GKR\u001c\u0007\u000eK\u0002\u0017\u0003g\t!\u0005^3tiVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[%o)J,hnY1uS>t\u0007fA\f\u00024\u0005\u0019C/Z:u+:\\gn\\<o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00165jY\u00164U\r^2iS:<\u0007f\u0001\r\u00024\u0005qA/Z:u)J,hnY1uS>t\u0007fA\r\u00024\u0005YD/Z:u)J,hnY1uKR{\u0007*[4i/\u0006$XM]7be.Le\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti:{GoU;qa>\u0014H/\u001a3)\u0007i\t\u0019$\u0001\u001duKN$HK];oG\u0006$X\rV8IS\u001eDw+\u0019;fe6\f'o[%g\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00138g_:{G/\u0011<bS2\f'\r\\3)\u0007m\t\u0019$A\u0019uKN$HK];oG\u0006$X\rV8IS\u001eDw+\u0019;fe6\f'o\u001b#ve&twMU3n_Z,\u0007+\u0019:uSRLwN\\:)\u0007q\t\u0019$\u0001\u0013uKN$HK];oG\u0006$\u0018n\u001c8TW&\u0004\b/\u001a3JM:{W\t]8dQ\u000eC\u0017M\\4fQ\ri\u00121G\u0001/i\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'.L\u0007\u000f]3e\u0013\u001a\u0004\u0016M\u001d;ji&|gNU3n_Z,G\rK\u0002\u001f\u0003g\tq\u0004^3ti\u001a{G\u000e\\8xKJ4U\r^2i\u001fV$xJ\u001a*b]\u001e,\u0007*[4iQ\ry\u00121G\u0001%i\u0016\u001cHOR3oG\u0016$wJ\u001a4tKR\u0014Vm]3u\u0003\u001a$XM](vi>3'+\u00198hK\"\u001a\u0001%a\r\u0002=Q,7\u000f\u001e$pY2|w/\u001a:GKR\u001c\u0007nT;u\u001f\u001a\u0014\u0016M\\4f\u0019><\bfA\u0011\u00024\u0005\u0019D/Z:u%\u0016$(/_!gi\u0016\u0014XK\\6o_^tG*Z1eKJ,\u0005o\\2i\u0013:d\u0015\r^3ti>3gm]3u\r\u0016$8\r\u001b\u0015\u0004E\u0005M\u0012a\t;fgR\u0014V\r\u001d7jG\u0006$XMQ1uG\",7/\u00169U_2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0004G\u0005M\u0012A\u0005;fgR\u001cuN\u001d:vaRlUm]:bO\u0016D3\u0001JA\u001a\u0003Y\"Xm\u001d;MK\u0006$WM]#q_\u000eD7\t[1oO\u0016$UO]5oO\u001a+gnY3e\r\u0016$8\r[#q_\u000eD7O\u0012:p[2+\u0017\rZ3sQ\r)\u00131G\u0001;i\u0016\u001cH\u000fT3bI\u0016\u0014X\t]8dQ\u000eC\u0017M\\4f\tV\u0014\u0018N\\4Tk\u000e\u001cWm]:gk24U\r^2i\u000bB|7\r[:Ge>lG*Z1eKJD3AJA\u001a\u0003A\"Xm\u001d;MK\u0006$WM]#q_\u000eD7\t[1oO\u0016$UO]5oO\u001a+Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193feR\u0019!0!&\t\u000f\u0005]u\u00051\u0001\u0002\u001a\u0006\u0019B.Z1eKJ,\u0005o\\2i\u001f:dU-\u00193feB\u0019\u0011(a'\n\u0007\u0005u%HA\u0002J]R\f1\u0007^3tiR\u0013XO\\2bi\u0016$v.\u00129pG\",e\u000eZ(gMN,Go\u001d#ve&twMU3n_Z,\u0007+\u0019:uSRLwN\\:)\u0007!\n\u0019$A(uKN$HK];oG\u0006$\u0018n\u001c8UQJ|wo]#yG\u0016\u0004H/[8o\u0013\u001adU-\u00193feJ+G/\u001e:ogB\u000b'\u000f^5uS>t7OT8u%\u0016\fX/Z:uK\u0012LeNR3uG\",\u0005o\\2ig\"\u001a\u0011&a\r\u0002qQ,7\u000f\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rS1oI2Lgn\u001a)beRLG/[8o\r\u0006LG.\u001e:f\tV\u0014\u0018N\\4BaB,g\u000eZ5oO\"\u001a!&a\r\u0002sQ,7\u000f\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rS1oI2Lgn\u001a)beRLG/[8o\r\u0006LG.\u001e:f\tV\u0014\u0018N\\4UeVt7-\u0019;j_:D3aKA\u001a\u0003-2XM]5gs\u001a+Go\u00195feRC'/Z1e\u0011\u0006tG\r\\5oOB\u000b'\u000f^5uS>tg)Y5mkJ,Gc\u0001>\u00024\"9\u0011Q\u0017\u0017A\u0002\u0005]\u0016a\u00024fi\u000eDWM\u001d\t\u0004\u0003\u0006e\u0016bAA^e\t\tRj\\2l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002'Q,7\u000f\u001e#jm\u0016\u0014x-\u001b8h\u000bB|7\r[:)\u00075\n\u0019$\u0001\u0018uKN$HK];oG\u0006$Xm\u00148GKR\u001c\u0007\u000eR8fg:{G\u000f\u0015:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\f\u0007f\u0001\u0018\u00024\u00059B/Z:u\u001b\u0006L(-Z+qI\u0006$X\rV8qS\u000eLEm\u001d\u0015\u0004_\u0005M\u0012!\f;fgRLuM\\8sK\u001a+Go\u00195SKN\u0004xN\\:f/\",g\u000eT3bI\u0016\u0014X\t]8dQ\u000eC\u0017M\\4fI\"\u001a\u0001'a\r")
public class AbstractFetcherThreadTest {
    private final boolean truncateOnFetch;
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Set<String> allMetricsNames() {
        return (Set)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$1 -> x$1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$22 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$22);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.start();
        scala.collection.mutable.Set brokerTopicStatsMetrics = CollectionConverters$.MODULE$.SetHasAsScala(fetcher.brokerTopicStats().allTopicsStats().metricMapKeySet()).asScala();
        Set fetcherMetrics = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$2(this, brokerTopicStatsMetrics, fetcherMetrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed waiting for all fetcher metrics to be registered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        scala.collection.immutable.Set metricNames = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$2 -> x$2.getName())).toSet();
        Assertions.assertTrue((boolean)metricNames.intersect(fetcherMetrics).isEmpty());
        Assertions.assertEquals((Object)brokerTopicStatsMetrics, (Object)metricNames.intersect((Set)brokerTopicStatsMetrics));
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()), (String)"Failed waiting for consumer lag metric");
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testDelay() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                throw new UnknownTopicIdException("Topic ID was unknown as expected for this test");
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long timeBeforeFirst = System.currentTimeMillis();
        fetcher.doWork();
        long firstWorkDuration = System.currentTimeMillis() - timeBeforeFirst;
        long timeBeforeSecond = System.currentTimeMillis();
        fetcher.doWork();
        long secondWorkDuration = System.currentTimeMillis() - timeBeforeSecond;
        Assertions.assertTrue((firstWorkDuration < secondWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue(((long)fetchBackOffMs <= secondWorkDuration ? 1 : 0) != 0, (String)new StringBuilder(70).append("secondWorkDuration: ").append(secondWorkDuration).append(" was not greater than or equal to fetchBackOffMs: ").append(fetchBackOffMs).toString());
    }

    @Test
    public void testPartitionsInError() {
        TopicPartition partition1 = new TopicPartition("topic1", 0);
        TopicPartition partition2 = new TopicPartition("topic2", 0);
        TopicPartition partition3 = new TopicPartition("topic3", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, partition1, partition2, partition3){
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final TopicPartition partition3$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition1$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition3$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.NONE.code()))}));
            }
            {
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.partition3$1 = partition3$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition1, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition2, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition3, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition1, leaderState);
        fetcher.mockLeader().setLeaderState(partition2, leaderState);
        fetcher.mockLeader().setLeaderState(partition3, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Option partition1FetchState = fetcher.fetchState(partition1);
        Option partition2FetchState = fetcher.fetchState(partition2);
        Option partition3FetchState = fetcher.fetchState(partition3);
        Assertions.assertTrue((boolean)partition1FetchState.isDefined());
        Assertions.assertTrue((boolean)partition2FetchState.isDefined());
        Assertions.assertTrue((boolean)partition3FetchState.isDefined());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition1FetchState.get()).isDelayed());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition2FetchState.get()).isDelayed());
        Assertions.assertFalse((boolean)((PartitionFetchState)partition3FetchState.get()).isDelayed());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$32 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$32, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))}))), true);
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$3 -> x$3.state()));
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)Nil$.MODULE$)), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$5 -> x$5.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$6 -> x$6.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$7 -> x$7.state()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncation$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final boolean isTruncationOnFetchSupported;

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isTruncationOnFetchSupported() {
                return this.isTruncationOnFetchSupported;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.isTruncationOnFetchSupported = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final boolean isOffsetForLeaderEpochSupported;
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return this.isOffsetForLeaderEpochSupported;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super(mockLeaderEndPoint$1, mockTierStateMachine$1, 0, 1, 0, new FailedPartitions());
                this.isOffsetForLeaderEpochSupported = false;
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super(mockLeaderEndPoint$2, mockTierStateMachine$2, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super(mockLeaderEndpoint$1, mockTierStateMachine$3, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super(mockLeaderEndpoint$2, mockTierStateMachine$4, 0, 1, 0, new FailedPartitions());
            }
        };
        PartitionState replicaState = PartitionState$.MODULE$.apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((int)1, (int)truncations.elem);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testTruncationOnFetchSkippedIfPartitionRemoved() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$2.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$2 = truncations$2;
                super(mockLeaderEndpoint$3, mockTierStateMachine$5, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 6L, 4))})));
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(3L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)endOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Map offsets = fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)offsets.keySet());
        Assertions.assertEquals((long)3L, (long)((PartitionFetchState)offsets.apply((Object)partition)).fetchOffset());
        OffsetForLeaderEpochResponseData.EpochEndOffset newEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(2L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)newEndOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$8 -> x$8.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }

            public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        int x$6 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        Nil$ replicaLog = Nil$.MODULE$;
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeLow() {
        int leaderEpoch = 4;
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$92 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$92, x$6);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, leaderEpoch, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, leaderEpoch, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpoch, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        if (this.truncateOnFetch()) {
            fetcher.doWork();
        }
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$9 -> x$9.state()));
        Assertions.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        int leaderEpoch = 4;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final AtomicInteger tries;

            public AtomicInteger tries() {
                return this.tries;
            }

            public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffset(topicPartition, leaderEpoch);
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.tries = new AtomicInteger(0);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, leaderEpoch, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpoch, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$10 -> x$10.state()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicateBatchesUpToLeaderEpoch() {
        int leaderEpoch = 4;
        TopicPartition partition = new TopicPartition("topic", 0);
        short x$1 = this.version();
        BrokerEndPoint x$2 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        boolean x$3 = true;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$2, x$3, x$1);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)Nil$.MODULE$, leaderEpoch, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, leaderEpoch - 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, leaderEpoch, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, leaderEpoch + 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("e".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpoch, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$11 -> x$11.state()));
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testReplicateBatchesUpToLeaderEpoch$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs up to the leader epoch");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)(leaderState.logEndOffset() - 1L), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchedData = super.fetch(fetchRequest);
                if (!this.fetchedOnce()) {
                    ByteBuffer buffer = ((MemoryRecords)((FetchResponseData.PartitionData)((Tuple2)fetchedData.head())._2()).records()).buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return fetchedData;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchedOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 1);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){
            private boolean fetchEpochsFromLeaderOnce;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    this.responseCallback().apply$mcV$sp();
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.changeLeaderEpochWhileFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$12 -> x$12.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        }
        fetcher.doWork();
        Assertions.assertEquals(fetcher.mockLeader().leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.responseCallback().apply$mcV$sp();
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AbstractFetcherThreadTest.changeLeaderEpochDuringFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$14 -> x$14.state()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.currentLeaderEpoch())));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        fetcher.doWork();
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return (Map)super.fetchEpochEndOffsets(partitions).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(unrequestedTp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(0L)));
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> fetcher.doWork());
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionLeaderEpoch, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                int x$6 = 0;
                super(mockLeaderEndpoint$4, mockTierStateMachine$6, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                int x$6 = 0;
                super(mockLeaderEndpoint$5, mockTierStateMachine$7, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.setReplicaState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(this.partition2()).map((Function1 & Serializable)x$16 -> x$16.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 1))}))), true);
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).map((Function1 & Serializable)x$17 -> x$17.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDivergingEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testDivergingEpochs$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateOnFetchDoesNotProcessPartitionData() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncateCalls = IntRef.create((int)0);
        IntRef processPartitionDataCalls = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, processPartitionDataCalls, truncateCalls){
            private final IntRef processPartitionDataCalls$1;
            private final IntRef truncateCalls$1;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
                ++this.processPartitionDataCalls$1.elem;
                return super.processPartitionData(topicPartition, fetchOffset, partitionLeaderEpoch, partitionData);
            }

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncateCalls$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.processPartitionDataCalls$1 = processPartitionDataCalls$1;
                this.truncateCalls$1 = truncateCalls$1;
                super(mockLeaderEndpoint$6, mockTierStateMachine$8, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$))))));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 1L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)6L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)Nil$.MODULE$)))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 4L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertEquals((int)0, (int)processPartitionDataCalls.elem);
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)1L, (long)replicaState.highWatermark());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertTrue((processPartitionDataCalls.elem >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)4L, (long)replicaState.highWatermark());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        TopicPartition partition = new TopicPartition("topic1", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)None$.MODULE$, 0L, 0))})));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), (Option)None$.MODULE$);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), this.topicIds().get((Object)partition.topic()));
        TopicPartition unknownPartition = new TopicPartition("unknown", 0);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownPartition).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIgnoreFetchResponseWhenLeaderEpochChanged() {
        void forReplica_minBytes;
        void forReplica_maxWait;
        void forReplica_replicaEpoch;
        void forReplica_replicaId;
        int newEpoch = 1;
        int initEpoch = 0;
        TopicPartition partition = new TopicPartition("topic", 0);
        short x$1 = this.version();
        BrokerEndPoint x$2 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        boolean x$3 = true;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$2, x$3, x$1);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        PartitionState replicaState = PartitionState$.MODULE$.apply(newEpoch);
        fetcher.setReplicaState(partition, replicaState);
        InitialFetchState initFetchState = FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, newEpoch);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)initFetchState)})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initEpoch, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), initEpoch, 1L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        java.util.Map partitionData = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new FetchRequest.PartitionData(Uuid.randomUuid(), 0L, 0L, 0x100000, Optional.of(Predef$.MODULE$.int2Integer(initEpoch)), Optional.of(Predef$.MODULE$.int2Integer(initEpoch))))}))).asJava();
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        long l = initEpoch;
        boolean bl2 = false;
        short forReplica_allowedVersion = 0;
        FetchRequest.Builder fetchRequestOpt = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, partitionData);
        fetcher.processFetchRequest(partitionData, fetchRequestOpt);
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset(), (String)"FetchResponse should be ignored when leader epoch does not match");
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsRemovedOnShutdown$2(AbstractFetcherThreadTest $this, scala.collection.mutable.Set brokerTopicStatsMetrics$1, Set fetcherMetrics$1) {
        Set<String> set = $this.allMetricsNames();
        SetOps setOps = brokerTopicStatsMetrics$1.$plus$plus((IterableOnce)fetcherMetrics$1);
        return !(set != null ? !set.equals((Object)setOps) : setOps != null);
    }

    public static final /* synthetic */ String $anonfun$testMetricsRemovedOnShutdown$3() {
        return "Failed waiting for all fetcher metrics to be registered";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncation$2(MockFetcherThread fetcher$10, TopicPartition partition$1) {
        fetcher$10.doWork();
        Buffer<RecordBatch> buffer = fetcher$10.replicaPartitionState(partition$1).log();
        Buffer<RecordBatch> buffer2 = fetcher$10.mockLeader().leaderPartitionState(partition$1).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncation$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerFetchOutOfRangeLow$3(MockFetcherThread fetcher$17, TopicPartition partition$3) {
        fetcher$17.doWork();
        Buffer<RecordBatch> buffer = fetcher$17.replicaPartitionState(partition$3).log();
        Buffer<RecordBatch> buffer2 = fetcher$17.mockLeader().leaderPartitionState(partition$3).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFollowerFetchOutOfRangeLow$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(MockFetcherThread fetcher$18, TopicPartition partition$4) {
        fetcher$18.doWork();
        Buffer<RecordBatch> buffer = fetcher$18.replicaPartitionState(partition$4).log();
        Buffer<RecordBatch> buffer2 = fetcher$18.mockLeader().leaderPartitionState(partition$4).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicateBatchesUpToLeaderEpoch$3(MockFetcherThread fetcher$19, TopicPartition partition$5) {
        fetcher$19.doWork();
        Buffer<RecordBatch> buffer = fetcher$19.replicaPartitionState(partition$5).log();
        Object object = fetcher$19.mockLeader().leaderPartitionState(partition$5).log().dropRight(1);
        return !(buffer != null ? !buffer.equals(object) : object != null);
    }

    public static final /* synthetic */ String $anonfun$testReplicateBatchesUpToLeaderEpoch$4() {
        return "Failed to reconcile leader and follower logs up to the leader epoch";
    }

    private final void changeLeaderEpochWhileFetchEpoch$1(MockFetcherThread fetcher$21, TopicPartition partition$6, int nextLeaderEpochOnFollower$1) {
        fetcher$21.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$6})));
        fetcher$21.setReplicaState(partition$6, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$1));
        fetcher$21.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$6), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition$6.topic()), 0L, nextLeaderEpochOnFollower$1))}))), true);
    }

    private static final void changeLeaderEpochDuringFetchEpoch$1(MockFetcherThread fetcher$22, TopicPartition partition$7, int nextLeaderEpochOnFollower$2) {
        fetcher$22.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$7})));
        fetcher$22.setReplicaState(partition$7, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$2));
    }

    public static final /* synthetic */ boolean $anonfun$testDivergingEpochs$2(MockFetcherThread fetcher$25, TopicPartition partition$8) {
        fetcher$25.doWork();
        Buffer<RecordBatch> buffer = fetcher$25.replicaPartitionState(partition$8).log();
        Buffer<RecordBatch> buffer2 = fetcher$25.mockLeader().leaderPartitionState(partition$8).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDivergingEpochs$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(MockFetcherThread fetcher$26, TopicPartition partition$9) {
        fetcher$26.doWork();
        Buffer<RecordBatch> buffer = fetcher$26.replicaPartitionState(partition$9).log();
        Buffer<RecordBatch> buffer2 = fetcher$26.mockLeader().leaderPartitionState(partition$9).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$3() {
        return "Failed to reconcile leader and follower logs";
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public AbstractFetcherThreadTest() {
        this.truncateOnFetch = true;
    }
}

