/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.common.errors.UnsupportedByAuthenticationException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YA\u0011\u0002\u0007\u0001A\u0002\u0003\u0007I\u0011A\r\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0003A\u0003\"C\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003\u001b\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015a\b\u0001\"\u0011~\u0005\u0019\"U\r\\3hCRLwN\u001c+pW\u0016t'+Z9vKN$8o\u00148QY\u0006Lg\u000eV3yiR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aC\u0005\u0003)-\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u00025A\u00111$J\u0007\u00029)\u0011QDH\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003?\u0001\nqa\u00197jK:$8O\u0003\u0002\u000fC)\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0013\t1CDA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\tIs\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0003V]&$\bb\u0002\u0019\u0004\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0014\u0001D1e[&t7\t\\5f]R\u0004\u0013a\u00032s_.,'oQ8v]R,\u0012\u0001\u000e\t\u0003UUJ!AN\u0016\u0003\u0007%sG/A\u0003tKR,\u0006\u000f\u0006\u0002*s!)!H\u0002a\u0001w\u0005AA/Z:u\u0013:4w\u000e\u0005\u0002=\u00076\tQH\u0003\u0002?\u007f\u0005\u0019\u0011\r]5\u000b\u0005\u0001\u000b\u0015a\u00026va&$XM\u001d\u0006\u0003\u0005\u000e\nQA[;oSRL!\u0001R\u001f\u0003\u0011Q+7\u000f^%oM>D#A\u0002$\u0011\u0005q:\u0015B\u0001%>\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0012GJ,\u0017\r^3BI6LgnQ8oM&<W#A&\u0011\t1\u000b6KX\u0007\u0002\u001b*\u0011ajT\u0001\u0005kRLGNC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ik%aA'baB\u0011Ak\u0017\b\u0003+f\u0003\"AV\u0016\u000e\u0003]S!\u0001W\b\u0002\rq\u0012xn\u001c;?\u0013\tQ6&\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.,!\ty&-D\u0001a\u0015\t\tw*\u0001\u0003mC:<\u0017BA2a\u0005\u0019y%M[3di\u0006YB/Z:u\t\u0016dWmZ1uS>tGk\\6f]J+\u0017/^3tiN$\"!\u000b4\t\u000b\u001dD\u0001\u0019A*\u0002\rE,xN];nQ\tA\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002m\u007f\u00051\u0001/\u0019:b[NL!A\\6\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\taZ<\bCA9u\u001b\u0005\u0011(BA:l\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA;s\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0001P_\u0011\u0002s\u0006)1N]1gi\u0006\n10\u0001\u0002{W\u0006AA/Z1s\t><h\u000eF\u0001*Q\tIq\u0010E\u0002=\u0003\u0003I1!a\u0001>\u0005%\te\r^3s\u000b\u0006\u001c\u0007\u000e")
public class DelegationTokenRequestsOnPlainTextTest
extends BaseRequestTest {
    private Admin adminClient;

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
    }

    public Map<String, Object> createAdminConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties()).forEach((key, value) -> config.put((String)key, value));
        return config;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testDelegationTokenRequests(String quorum) {
        this.adminClient_$eq(Admin.create(this.createAdminConfig()));
        CreateDelegationTokenResult createResult = this.adminClient().createDelegationToken();
        boolean cfr_ignored_0 = Assertions.assertThrows(ExecutionException.class, () -> createResult.delegationToken().get()).getCause() instanceof UnsupportedByAuthenticationException;
        DescribeDelegationTokenResult describeResult = this.adminClient().describeDelegationToken();
        boolean cfr_ignored_1 = Assertions.assertThrows(ExecutionException.class, () -> describeResult.delegationTokens().get()).getCause() instanceof UnsupportedByAuthenticationException;
        RenewDelegationTokenResult renewResult = this.adminClient().renewDelegationToken("".getBytes());
        boolean cfr_ignored_2 = Assertions.assertThrows(ExecutionException.class, () -> renewResult.expiryTimestamp().get()).getCause() instanceof UnsupportedByAuthenticationException;
        ExpireDelegationTokenResult expireResult = this.adminClient().expireDelegationToken("".getBytes());
        boolean cfr_ignored_3 = Assertions.assertThrows(ExecutionException.class, () -> expireResult.expiryTimestamp().get()).getCause() instanceof UnsupportedByAuthenticationException;
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
        super.tearDown();
    }
}

